package com.xforceplus.elephant.image.controller.image.process;

import com.xforceplus.elephant.basecommon.enums.image.ImageOperateTypeEnum;
import com.xforceplus.elephant.basecommon.enums.image.ImageReservedEnum;
import com.xforceplus.elephant.basecommon.enums.image.ImageSourceEnum;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.process.AbstractKeyProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.SaveImageOrCopyRequest;
import com.xforceplus.elephant.image.core.business.infrastructure.port.FileService;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.elephant.image.core.domain.image.ImageCopyService;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ExceptionStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.RecStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.ImageCopy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ValidationException;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaveImageOrCopyBase64Process extends AbstractKeyProcess<Long, SaveImageOrCopyRequest, Boolean> {

    @Autowired
    private ImageService imageService;
    @Autowired
    private ImageCopyService imageCopyService;
    @Autowired
    private FileService fileService;
    @Autowired
    private BaseBillService baseBillService;
    @Autowired
    private BillImageTicketService billImageTicketService;

    @Override
    protected void check(Long imageId, SaveImageOrCopyRequest request) throws ValidationException {
        super.check(imageId, request);
        checkEmpty(request.getType(), "处理方式不能为空");
        if (ImageOperateTypeEnum.MAKE_COVER.getCode().equals(request.getType())) {
            checkEmpty(request.getBillCode(), "业务单号不能为空");
        }
        checkEmpty(request.getImageContent(), "影像内容不能为空");
        if (!request.getImageContent().startsWith("data:image/") || request.getImageContent().split(",").length != 2) {
            throw new ValidationException("影像内容不是base64，无法解析");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(Long imageId, SaveImageOrCopyRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        Image entity = null;
        if (imageId != null && imageId > 0) {
            entity = imageService.selectOne(user.getTenantId(), imageId);
        }
        if (entity == null) {
            return CommonResponse.failed("影像不存在或已删除");
        }
        BaseBill baseBill = null;
        boolean hasCover = false;
        if (ImageOperateTypeEnum.MAKE_COVER.getCode().equals(request.getType())) {
            baseBill = baseBillService.selectBaseBillByCode(user.getTenantId(), request.getBillCode());
            checkEmpty(baseBill, "单据不存在");
            final List<Image> sellerList = imageService.selectBillReservedImages(user.getTenantId(),
                baseBill.getBillCode(), ImageReservedEnum.RESERVED2,
                YesNo._1.getCode().toString());
            if (sellerList.size() > 0) {
                entity = sellerList.get(0);
            }
            if (baseBill.getImageId() != null && baseBill.getImageId() > 0) {
                hasCover = true;
            }
        }

        final Pattern pattern = Pattern.compile("data:image/(\\w+);base64,");
        final Matcher matcher = pattern.matcher(request.getImageContent());
        String fileExt = "jpg";
        if (matcher.find()) {
            fileExt = matcher.group(1);
        }
        final String fileName = new StringBuilder("image_").append(imageId)
            .append("_").append(System.currentTimeMillis())
            .append(".").append(fileExt)
            .toString();
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            final String imageContent = request.getImageContent().split(",")[1];
            final byte[] imgBytes = Base64.getDecoder().decode(imageContent);
            final Thumbnails.Builder builder = Thumbnails.of(new ByteArrayInputStream(imgBytes)).scale(1).outputQuality(0.5);
            if (ValidatorUtil.isNotEmpty(request.getRotate())) {
                builder.rotate(request.getRotate());
            }
            builder.toOutputStream(baos);
        } catch (IOException e) {
            throw new ElephantException("图片处理异常");
        }
        final Long fileId = fileService.uploadFile(user.getTenantId(), user.getId(), fileName, new ByteArrayInputStream(baos.toByteArray()));
        final String fileKey = fileService.getFileUrl(user.getTenantId(), user.getId(), fileId);
        switch (ImageOperateTypeEnum.fromCode(request.getType())) {
            case COVER_ORIGIN:
                final Image temp = new Image();
                temp.setId(imageId);
                temp.setFileUrlOrigin(entity.getFileUrlHandle());
                temp.setFileUrlHandle(fileKey);
                imageService.coverImage(temp);
                break;
            case MAKE_COPY:
                final ImageCopy copy = new ImageCopy();
                copy.setParentImageId(imageId);
                copy.setCopyName(request.getCopyName());
                copy.setFileUrl(fileKey);
                copy.setFileType("." + fileExt);
                imageCopyService.saveImageCopy(copy);
                break;
            case MAKE_COVER:
                if (entity != null) {
                    final Image update = new Image();
                    update.setId(entity.getId());
                    update.setFileUrl(fileKey);
                    update.setFileUrlHandle(fileKey);
                    update.setFileType("." + fileExt);
                    update.setFileTypeHandle("." + fileExt);
                    imageService.updateImageSelective(update);
                    break;
                }
                final Image cover = new Image();
                cover.setTenantId(user.getTenantId());
                cover.setBatchNo(Long.toString(System.currentTimeMillis()));
                cover.setBillCode(request.getBillCode());
                cover.setFileUrl(fileKey);
                cover.setFileUrlHandle(fileKey);
                cover.setFileType("." + fileExt);
                cover.setFileTypeHandle("." + fileExt);
                cover.setImageSource(ImageSourceEnum.UPLOAD.getCode().toString());
                cover.setImageType(ImageType._99.getCode());
                cover.setFileOrder("0");
                if (hasCover) {
                    final Image firstImage = imageService.selectOne(user.getTenantId(), baseBill.getImageId());
                    if (firstImage != null) {
                        final Image update = new Image();
                        update.setId(firstImage.getId());
                        update.setFileOrder(firstImage.getFileOrder() + "0");
                        imageService.updateImageSelective(update);
                        cover.setFileOrder(firstImage.getFileOrder() + "1");
                    }
                }
                cover.setRequireOcrFlag(YesNo._0.getCode());
                cover.setRecStatus(RecStatus._2.getCode());
                cover.setStatus(ImageStatus._1.getCode());
                cover.setIsManualUnhook(YesNo._0.getCode());
                cover.setExceptionStatus(ExceptionStatus._0.getCode());
                cover.setReturnStatus(BackType._0.getCode());
                cover.setIsPublic(YesNo._1.getCode());
                cover.setFileUrlLocal(StringUtils.EMPTY);
                cover.setCreateUserCode(user.getUserCode());
                cover.setBillEntityCode(baseBill.getBillTypeCode());
                cover.setReserved2(YesNo._1.getCode().toString());
                cover.setReserved3(YesNo._0.getCode().toString());
                final List<Long> ids = imageService.saveImages(Arrays.asList(cover));
                if (ids.size() == 0) {
                    return CommonResponse.failed("发票清单创建失败");
                }
                break;
            default:
                break;
        }
        return CommonResponse.ok("成功", true);
    }

}