package com.xforceplus.elephant.image.controller.image.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.baseconst.ReleationConstants;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.help.FileUtils;
import com.xforceplus.elephant.basecommon.help.RandomUtil;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.UploadRequest;
import com.xforceplus.elephant.image.core.business.application.collect.batch.domain.EnableFlowContext;
import com.xforceplus.elephant.image.core.business.application.collect.batch.service.BatchService;
import com.xforceplus.elephant.image.core.business.application.config.common.enums.ReceiveFilterEnums;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.consts.Constants;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.domain.ticket.TicketService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.elephant.image.core.facade.application.collect.upload.UploadFacade;
import com.xforceplus.elephant.image.core.facade.application.config.dictionary.extfields.ExtFieldsReceiveFacade;
import com.xforceplus.elephant.image.core.repository.model.BatchTaskEntity;
import com.xforceplus.elephant.image.core.util.ImageUtils;
import com.xforceplus.purchaser.bizratelimiter.model.Application;
import com.xforceplus.purchaser.bizratelimiter.model.BizRequest;
import com.xforceplus.purchaser.bizratelimiter.model.Channel;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.CalculateStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.RecStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.ImageFile;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.xlog.core.model.LogContext;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.groovy.util.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 上传附件
 *
 * @author rongying
 * @date 2021/8/17 10:53
 */
@Dispatch(isDefault = true)
@Service
public class UploadAttachImageProcess extends AbstractProcess<UploadRequest, Boolean> {

    @Autowired
    private ImageService imageService;
    @Autowired
    private TicketService ticketService;
    @Autowired
    private ExtFieldsReceiveFacade extFieldsReceiveFacade;
    @Autowired
    private UploadFacade uploadFacade;
    @Autowired
    private BillImageTicketService billImageTicketService;
    @Autowired
    private BatchService batchService;
    @Autowired
    private MQUtils mqUtils;
    @Autowired(required = false)
    private Application application;

    @Override
    protected void check(UploadRequest request) throws ValidationException {
        checkEmpty(request.getUploadImageDTOList(), "影像数据不能为空!");
        checkEmpty(request.getParentImageId(), "父影像ID不能为空!");
    }

    @Override
    protected CommonResponse<Boolean> process(UploadRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        if (ValidatorUtil.isEmpty(user)) {
            return CommonResponse.failed("用户信息获取失败!");
        }
        //查询父影像
        final Image image = imageService.selectOne(user.getTenantId(), request.getParentImageId());
        if (ValidatorUtil.isEmpty(image)) {
            return CommonResponse.failed("父影像数据不存在!");
        }
        if (ValidatorUtil.isNotEmpty(image.getImageType()) && ImageType._99.getCode().equals(image.getImageType())) {
            return CommonResponse.failed("当前影像类型为附件，不可上传附件!");
        }
        //查询父结构数据
        final List<Map<String, Object>> ticketMapList = ticketService.selectTicketByImageIds(user.getTenantId(), Arrays.asList(request.getParentImageId()));
        if (ValidatorUtil.isEmpty(ticketMapList)) {
            return CommonResponse.failed("父影像对应的单证数据不存在!");
        }
        final String[] fileOrder = {image.getFileOrder()};
        final JSONObject ticketJson = BeanUtils.convertJSON(ticketMapList.get(0));
        final String batchNo = System.currentTimeMillis() + String.valueOf(RandomUtil.randomInt(99999));
        final AtomicInteger index = new AtomicInteger();
        final EnableFlowContext context = new EnableFlowContext().setTenantId(user.getTenantId()).setUserId(user.getId());
        final boolean flag = batchService.enable(context);
        LogContext.setLogPoint("enableFlow", flag);
        final List<String> failedList = new ArrayList<>();//上传失败文件
        final List<JSONObject> requestDtos = new ArrayList<>();
        request.getUploadImageDTOList().forEach(uploadImageDTO -> {
            final String newFileOrder = fileOrder[0] + ImageUtils.sequence(index.incrementAndGet(), request.getUploadImageDTOList().size());
            //获取影像上传地址
            final String fileUrl = uploadFacade.getUploadImageUrl(user.getTenantId(), user.getId(), uploadImageDTO.getFileStream(), uploadImageDTO.getFileType(), new ImageFile());
            if (ValidatorUtil.isEmpty(fileUrl)) {
                failedList.add(uploadImageDTO.getFileName() + uploadImageDTO.getFileType());
                return;
            }
            final String fileSuffix = FileUtils.getFileSuffix(fileUrl);
            final Image entity = new Image();
            entity.setBatchNo(batchNo);
            entity.setFileOrder(newFileOrder);
            entity.setStatus(ImageStatus._1.getCode());
            entity.setIsManualUnhook(YesNo._0.getCode());
            entity.setExceptionStatus(YesNo._0.getCode());
            entity.setReturnStatus(BackType._0.getCode().toString());
            entity.setFileUrlLocal(StringUtils.EMPTY);
            entity.setFileName(uploadImageDTO.getFileName());
            entity.setFileUrl(fileUrl);
            entity.setFileType(fileSuffix);
            entity.setFileTypeHandle(fileSuffix);
            entity.setFileUrlHandle(fileUrl);
            entity.setTenantId(user.getTenantId());
            entity.setIsPublic(image.getIsPublic().toString());
            entity.setCreateUserCode(user.getUserCode());
            entity.setCreateUserId(user.getId());
            entity.setCreateUserName(user.getUsername());
            entity.setRecStatus(RecStatus._2.getCode().toString());
            entity.setRequireOcrFlag(YesNo._0.getCode().toString());
            entity.setImageSource(request.getSystemOrig());
            entity.setBillEntityCode(image.getBillEntityCode());
            entity.setSerialNumber(image.getSerialNumber());
            entity.setBillCode(image.getBillCode());
            entity.setImageType(ImageType._99.getCode());
            entity.setTicketCode(EntityMeta.TicketAttachment.code());
            entity.setTicketImageId(image.getId());
            entity.setCalculateStatus(CalculateStatus._1.getCode());
            final JSONObject json = new JSONObject(entity.toOQSMap());
            if (ValidatorUtil.isNotEmpty(request.getExt())) {
                json.putAll(extFieldsReceiveFacade.getExtFields(user.getTenantId(), ReceiveFilterEnums.IMAGE, request.getExt()));
            }
            List<Long> imageIds = new ArrayList<>();
            if (!flag) {
                imageIds = imageService.saveForMap(Arrays.asList(json));
                if (ValidatorUtil.isEmpty(imageIds)) {
                    throw new ElephantException("保存影像失败");
                }
            }
            //map创建对象会清除create信息
            final Image imageObj = Image.fromOQSMap(json);
            imageObj.setCreateUserId(entity.getCreateUserId());
            imageObj.setCreateUserName(entity.getCreateUserName());
            imageObj.setCreateTime(LocalDateTime.now());
            if (CollectionUtils.isNotEmpty(imageIds)) {
                imageObj.setId(imageIds.get(0));
            }
            final Map<String, Object> ticket = new HashMap<>();
            ticket.put(ReleationConstants.TICKET_OTM_TICKET_ID, ticketJson.getLong(EntityMeta.Ticket.ID.code()));
            if (!flag) {
                final Long ticketId = uploadFacade.saveTicketAttach(imageObj, ticket, EntityMeta.TicketAttachment.code());
                if (ValidatorUtil.isEmpty(ticketId)) {
                    logger.error("保存单证失败,影像ID：{}", imageIds.get(0));
                    throw new ElephantException("保存单证失败");
                }
                return;
            }
            final JSONObject dto = new JSONObject();
            dto.put("image", json);
            dto.put("ticket", ticket);
            requestDtos.add(dto);
        });
        if (flag) {
            final String channelCode = batchService.getChannelCode(user.getTenantCode());
            final BatchTaskEntity batchTaskEntity = new BatchTaskEntity();
            batchTaskEntity.setTenantId(user.getTenantId());
            batchTaskEntity.setTenantCode(user.getTenantCode());
            batchTaskEntity.setCreateUserId(user.getId());
            batchTaskEntity.setCreateUserName(user.getUsername());
            batchTaskEntity.setCreateTime(new Date());
            batchTaskEntity.setTaskCount(requestDtos.size());
            batchTaskEntity.setChannelCode(channelCode);
            final Long batchId = batchService.insert(batchTaskEntity);
            requestDtos.forEach(dto -> {
                dto.getJSONObject("image").put(EntityMeta.Image.BATCH_NO.code(), batchId);
            });
            final Map<String, Object> headers = new HashMap<>();
            headers.put(Constants.TENANT_CODE, user.getTenantCode());
            headers.put("batchNo", batchId);
            headers.put("userInfo", JSONObject.toJSONString(user));
            final Map<String, Object> body = new HashMap<>(2);
            body.put("ticketJson", ticketJson);
            body.put("requestDtos", requestDtos);
            try {
                if (batchService.sendEnableFlow(context)) {
                    final Channel channel = application.loadChannel(channelCode);
                    final BizRequest bizRequest = BizRequest.builder()
                        .bizQuantity(batchTaskEntity.getTaskCount())
                        .properties(headers)
                        .body(JSONObject.toJSONString(body))
                        .attrs(Maps.of("queueName", MQEnum.UPLOAD_ATTACH_IMAGE_SYNC_QUEUE))
                        .build();
                    channel.flowInRateLimit(bizRequest);
                } else {
                    mqUtils.sendByDirectExchange(MQEnum.UPLOAD_ATTACH_IMAGE_SYNC_QUEUE, JSONObject.toJSONString(body), headers);
                }
            } catch (Exception e) {
                LogContext.setLogPoint("enableFlowError", e.getMessage());
                logger.error("使用限流异常", e);
                LogContext.setLogPoint("error", String.format("使用限流异常:%s", e.getMessage()));
                mqUtils.sendByDirectExchange(MQEnum.UPLOAD_ATTACH_IMAGE_SYNC_QUEUE, JSONObject.toJSONString(body), headers);
            }
            return CommonResponse.ok("成功");
        }
        //重算发票异常
        final JSONObject updateJson = billImageTicketService.checkTicketExceAndWarn(user.getTenantId(), ticketJson);
        if (ValidatorUtil.isNotEmpty(updateJson)) {
            final Integer count = ticketService.updateTicketByParam(ticketJson.getLong(EntityMeta.Ticket.ID.code()), ticketJson.getString(EntityMeta.Ticket.TICKET_CODE.code()), updateJson);
            if (count > 0) {
                final long imageId = ticketJson.getLong(EntityMeta.Ticket.IMAGE_ID.code());
                billImageTicketService.updateManyExceWarnData(imageId);
                //修改影像
                billImageTicketService.updateImageExceWarnData(user.getTenantId(), imageId);
            }
        }
        final String billCode = ticketJson.getString(EntityMeta.Ticket.BILL_CODE.code());
        if (ValidatorUtil.isNotEmpty(billCode)) {
            billImageTicketService.updateRecogBillInfo(user.getTenantId(), billCode);
        }
        if (ValidatorUtil.isNotEmpty(failedList)) {
            final String message = String.format("共上传%d条，其中%d条上传成功，%d条上传失败", request.getUploadImageDTOList().size(),
                request.getUploadImageDTOList().size() - failedList.size(), failedList.size());
            logger.info("uploadAttachImage上传失败【{}】", failedList.stream().collect(Collectors.joining(",")));
            return CommonResponse.ok(message);
        }
        return CommonResponse.ok("上传成功");
    }

}
