package com.xforceplus.elephant.image.controller.image.process.cover;

import static com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.baseconst.ReleationConstants;
import com.xforceplus.elephant.basecommon.baseconst.SettingsConstants;
import com.xforceplus.elephant.basecommon.enums.EntityConstant;
import com.xforceplus.elephant.basecommon.enums.common.WebsocketNoticeTypeEnum;
import com.xforceplus.elephant.basecommon.enums.cqp.bill.BackTypeEnum;
import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.system.paas.NotificationUtils;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.ImageDTO;
import com.xforceplus.elephant.image.client.model.UpdateImageRequest;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.elephant.image.core.domain.config.ConfigSettingsService;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.RecStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Dispatch(tenantCode = "CQP")
@Service
public class CQPReplaceCoverImageProcess extends DefaultReplaceCoverImageProcess {

    @Autowired
    private ImageService imageService;
    @Autowired
    private BaseBillService baseBillService;
    @Autowired
    private ConfigSettingsService configSettingsService;
    @Autowired
    private MQUtils rabbitmqUtils;
    @Autowired
    private NotificationUtils notificationUtils;
    @Autowired
    private BillImageTicketService billImageTicketService;

    @Override
    protected void check(UpdateImageRequest request) throws ValidationException {
        checkEmpty(request.getEntities(), "封面不能为空");
        checkEmpty(request.getBillCode(), "原业务单号不能为空 ");
        checkEmpty(request.getEntities(), "封面不能为空");
    }

    @Override
    protected CommonResponse<Boolean> process(UpdateImageRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();

        final BaseBill baseBill = baseBillService.selectBaseBillByCode(authorizedUser.getTenantId(), request.getBillCode());
        if (ValidatorUtil.isNotEmpty(baseBill)) {
            if (YesNo._0.getCode().equals(baseBill.getIsPushBill())
                && BillDataStatus._4.getCode().equals(baseBill.getBillDataStatus())
                && BackType._2.getCode().equals(baseBill.getBackType())) {
                return CommonResponse.failed("请等待经办人重新提交单据后，再次尝试操作。");
            }
        }

        final long exsitemptybillcode = request.getEntities().stream().filter(r -> ValidatorUtil.isEmpty(r.getBillCode())).count();
        if (exsitemptybillcode > 0 && exsitemptybillcode < request.getEntities().size()) {
            final String failMessage = "替扫封面时，含有非封面的发票或附件，此次替扫不生效";
            final String message = sendMessage(request.getBillCode(), authorizedUser, failMessage);
            return CommonResponse.failed(message);
        }
        if (exsitemptybillcode > 0 && exsitemptybillcode == request.getEntities().size()) {
            final String failMessage = "替扫封面时，没有单据头信息，此次替扫不生效";
            final String message = sendMessage(request.getBillCode(), authorizedUser, failMessage);
            return CommonResponse.failed(message);
        }
        final long count = request.getEntities().stream().map(r -> r.getBillCode()).distinct().count();
        if (count > 1) {
            final String failMessage = "替扫封面时，含有多张单据信息，此次替扫不生效，请核实后重新替扫";
            final String message = sendMessage(request.getBillCode(), authorizedUser, failMessage);
            return CommonResponse.failed(message);
        }

        String ocrBillCode = request.getEntities().get(0).getBillCode();
        final String regexSplit = configSettingsService.select(UserInfoHolder.get().getTenantId(), SettingsConstants.BILL_CODE_REGEX_SPLIT);

        if (ValidatorUtil.isNotEmpty(regexSplit)) {
            for (String reg : regexSplit.split(",")) {
                final Pattern pattern = Pattern.compile(reg);
                final Matcher matcher = pattern.matcher(ocrBillCode);
                if (matcher.find()) {
                    ocrBillCode = matcher.group(1);
                    break;
                }
            }
        }

        if (!request.getBillCode().equals(ocrBillCode)) {
            final String failMessage = "替扫封面时，单据号与之前的不一致，此次替扫不生效";
            final String message = sendMessage(request.getBillCode(), authorizedUser, failMessage);
            return CommonResponse.failed(message);
        }

        final List<Image> entity = imageService.selectCoversByBillCode(authorizedUser.getTenantId(), request.getBillCode());
        if (entity == null) {
            return CommonResponse.failed("当前单据没有封面无法替换");
        }
        //封装单据信息
        final Map<String, List<ImageDTO>> dtoMap = dtoMap(request.getEntities());
        //查询已有单据
        final Map<String, BaseBill> billMap = billMap(dtoMap);
        //先删除
        final List<Long> daleteImageIds = entity.stream().map(r -> r.getId()).collect(Collectors.toList());
        billImageTicketService.deleteImages(authorizedUser.getTenantId(), daleteImageIds);
        final int newCoverCount = entity.size() - request.getEntities().size();
        //保存
        final List<Long> imageIds = saveImages(dtoMap, billMap, newCoverCount, entity.get(0).getFileOrder());

        if (BillDataStatus._4.getCode().equals(baseBill.getBillDataStatus()) && BackType._1.getCode().equals(baseBill.getBackType())) {
            //退回替扫后重置推送待办状态
            final JSONObject update = new JSONObject();
            //重庆医药 is_cover 标志是否替扫过
            update.put("is_cover", YesNo._1.getCode());
            baseBillService.updateByBillIdSelective(baseBill.getId(), update);
        }

        return CommonResponse.ok("成功");
    }

    /**
     * 根据单据组装请求dtos
     *
     * @param entities entities
     * @return
     */
    private Map<String, List<ImageDTO>> dtoMap(List<ImageDTO> entities) {
        final Map<String, List<ImageDTO>> dtoMap = new LinkedHashMap<>();
        String billCode = StringUtils.EMPTY;
        final String regexSplit = configSettingsService.select(UserInfoHolder.get().getTenantId(), SettingsConstants.BILL_CODE_REGEX_SPLIT);
        for (ImageDTO entity : entities) {
            billCode = entity.getBillCode();
            entity.setImageType(ImageType._1.getCode());
            entity.setRequireOcrFlag(YesNo._0.getCode());
            entity.setRecStatus(RecStatus._2.getCode());
            entity.setCalculateStatus(YesNo._1.getCode());
            if (ValidatorUtil.isNotEmpty(regexSplit)) {
                for (String reg : regexSplit.split(",")) {
                    final Pattern pattern = Pattern.compile(reg);
                    final Matcher matcher = pattern.matcher(billCode);
                    if (matcher.find()) {
                        billCode = matcher.group(1);
                        break;
                    }
                }
            }
            if (!dtoMap.containsKey(billCode)) {
                dtoMap.put(billCode, new ArrayList<>());
            }
            dtoMap.get(billCode).add(entity);
            entity.setBillCode(billCode);
        }
        return dtoMap;
    }

    /**
     * 根据扫描的单据号查询系统中对应的单据
     *
     * @param dtoMap 单据dtoMap
     * @return
     */
    private Map<String, BaseBill> billMap(Map<String, List<ImageDTO>> dtoMap) {
        final List<String> billCodes = dtoMap.keySet().stream()
            .filter(billCode -> ValidatorUtil.isNotEmpty(billCode))
            .collect(Collectors.toList());
        if (ValidatorUtil.isEmpty(billCodes)) {
            return new HashMap<>();
        }
        final Map<String, BaseBill> billMap = new HashMap<>();
        final long tenantId = UserInfoHolder.get().getTenantId();
        baseBillService.selectBillDataByBillCodes(tenantId, billCodes)
            .forEach(bill -> {
                billMap.put(bill.getBillCode(), bill);
                dtoMap.get(bill.getBillCode()).forEach(dto -> {
                    dto.setOrgId(bill.getOrgId());
                    dto.setOrgCode(bill.getOrgCode());
                    dto.setOrgName(bill.getOrgName());
                    dto.setBillEntityCode(bill.getBillTypeCode());
                });
            });
        return billMap;
    }

    /**
     * 存储影像
     *
     * @param dtoMap  单据dtoMap
     * @param billMap 单据Map
     * @return
     */
    private List<Long> saveImages(Map<String, List<ImageDTO>> dtoMap, Map<String, BaseBill> billMap, int newCoverCount, String fileOrder) {
        final IAuthorizedUser user = UserInfoHolder.get();
        final String batchNo = Long.toString(System.currentTimeMillis());
        final List<JSONObject> images = new ArrayList<>();
        final Map<String, JSONObject> billImagesMap = new HashMap<>();
        dtoMap.entrySet().stream().forEach(entry -> {
            final BaseBill billEntity = billMap.get(entry.getKey());  //通过billcode拿到对应的单据信息
            billEntity.setBatchNo(batchNo);   //单据信息更新
            final Long imageCount = billEntity.getImageCount();
            billEntity.setImageCount(imageCount - newCoverCount);
            billEntity.setScanUserId(user.getId());
            billEntity.setScanUserName(user.getUsername());
            billEntity.setCreateUserCode(user.getUserCode());
            updateBill(billEntity); //更新单据信息
            entry.getValue().forEach(dto -> {       //对上传的影像信息更新
                final JSONObject image = BeanUtils.convertJSON(dto);
                image.put("batch_no", batchNo);
                image.put("file_order", fileOrder);
                image.put("create_user_code", user.getUserCode());
                image.put("is_public", YesNo._1.getCode());
                //单据影像一对多关系
                image.put(ReleationConstants.BILL_OTM_IMAGE_ID, billEntity.getId());
                if (ImageType._1.getCode().equals(dto.getImageType())) {      //如果是单据的影像，那么就加到单据的影像列表中
                    if (!billImagesMap.containsKey(image.getString("bill_code"))) {
                        billImagesMap.put(image.getString("bill_code"), image);
                    }
                }
                images.add(image);
            });
        });
        final List<Long> ids = imageService.saveForMap(images); //保存影像信息
        //更新单据影像一对一关系
        final List<JSONObject> billImages = billImagesMap.values().stream().collect(Collectors.toList());
        billImages.forEach(image -> {
            final Long billId = image.getLong(ReleationConstants.BILL_OTM_IMAGE_ID);
            final Long imageId = image.getLong("id");
            final JSONObject bill = new JSONObject();
            bill.put("image_id", imageId);
            bill.put(ReleationConstants.BILL_OTO_IMAGE_ID, imageId);
            baseBillService.updateByBillIdSelective(billId, bill);
        });
        return ids;
    }

    /**
     * 更新单据
     *
     * @param billEntity billEntity
     */
    private void updateBill(BaseBill billEntity) {
        //单据保存
        final JSONObject update = new JSONObject();
        update.put("is_push_bill", billEntity.getIsPushBill());
        update.put("image_count", billEntity.getImageCount());
        update.put("scan_user_id", billEntity.getScanUserId());
        update.put("scan_user_name", billEntity.getScanUserName());
        update.put("scan_create_time", System.currentTimeMillis());
        update.put("create_user_code", billEntity.getCreateUserCode());
        update.put("batch_no", billEntity.getBatchNo());
        update.put("bill_data_status", billEntity.getBillDataStatus());
        logger.info("更新单据，bill_code：【{}】，update：【{}】", billEntity.getBillCode(), update);
        baseBillService.updateBillData(EntityConstant.BASE_BILL, billEntity.getId(), update);
        //发送通知
        final JSONObject mqMessage = new JSONObject();
        mqMessage.put("noticeType", WebsocketNoticeTypeEnum.IMAGE_DISCERN.getCode());
        mqMessage.put("tenantId", billEntity.getTenantId());
        mqMessage.put("source", "重药替扫");
        mqMessage.put("createUserId", billEntity.getScanUserId());
        mqMessage.put("billCode", billEntity.getBillCode());
        mqMessage.put("isBill", true);
        final Map<String, Object> headers = new HashMap<>();
        headers.put(TENANT_CODE, billEntity.getTenantCode());
        rabbitmqUtils.sendByTopicExchange(MQEnum.WEBSOCKET_NOTICE_QUEUE, mqMessage, headers);
    }

    private String sendMessage(String billCode, IAuthorizedUser authorizedUser, String failMessage) {
        final StringBuilder sb = new StringBuilder();
        sb.append(billCode);
        sb.append(failMessage);
        final String message = sb.toString();
        notificationUtils.sendSingleMessage(authorizedUser.getTenantId(), Arrays.asList(authorizedUser.getId()), "替扫失败", message);
        return message;
    }

}
