package com.xforceplus.elephant.image.controller.image.process.delete;

import com.google.api.client.util.Lists;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.enums.bill.ExtStatusEnum;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.BillSelectAllRequest;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.domain.ticket.TicketService;
import com.xforceplus.elephant.image.core.expand.bean.AsyncHandleTicketBean;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.CommitStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import java.util.List;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 融创集团
 *
 * @author rongying
 * @date 2021/8/4 13:40
 */
@Dispatch(tenantCode = "RCJT")
@Service
@RequiredArgsConstructor
public class RCJTDeleteImageProcess extends DefaultDeleteImageProcess {

    @Autowired
    private TicketService ticketService;
    @Autowired
    private ImageService imageService;

    @Override
    protected String filter(BillSelectAllRequest request) {
        final StringBuffer message = new StringBuffer("共勾选").append(request.getIds().size()).append("条");
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        //JXCPX-1935 可删除识别中、转化中数据
        /*final List<Image> images = imageService.selectImages(authorizedUser.getTenantId(), request.getIds());
        final long noFinishRecCount = images.stream()
            .filter(entity -> !Arrays.asList(RecStatus._2.getCode(), RecStatus._3.getCode()).contains(String.valueOf(entity.getRecStatus())))
            .map(entity -> request.getIds().remove(entity.getId()))
            .count();*/
        //可删除的发票
        final Integer[] lockCount = {0};
        //查询发票
        final List<Ticket> ticketList = ticketService.selectBaseTicketByImageIds(authorizedUser.getTenantId(), request.getIds());
        final List<Long> deleteImageIds = Lists.newArrayList();
        final List<Long> deleteTicketIds = Lists.newArrayList();
        if (ValidatorUtil.isNotEmpty(ticketList)) {
            ticketList.stream().forEach(item -> {
                //已锁定发票
                if (ValidatorUtil.isNotEmpty(item.getTicketStatus()) && ExtStatusEnum.BEEN_SUBMITTED.getCode().toString().equals(item.getTicketStatus())) {
                    lockCount[0]++;
                    request.getIds().remove(item.getImageId());
                    return;
                }
                if (ValidatorUtil.isEmpty(item.getCommitStatus()) || CommitStatus._0.getCode().equals(item.getCommitStatus())) {
                    return;
                }
                deleteImageIds.add(item.getImageId());
                deleteTicketIds.add(item.getId());
            });
        }
        if (ValidatorUtil.isNotEmpty(deleteImageIds)) {
            final AsyncHandleTicketBean asyncHandleTicketBean = new AsyncHandleTicketBean();
            asyncHandleTicketBean.setTenantId(authorizedUser.getTenantId());
            asyncHandleTicketBean.setImageIds(deleteImageIds);
            asyncHandleTicketBean.setTicketIds(deleteTicketIds);
            asyncHandleTicketBean.setTicketStatus(ExtStatusEnum.DELETE_SUCCESS.getCode());

        }

        //JXCPX-1935 可删除识别中、转化中数据
        //if (noFinishRecCount == 0 && lockCount[0] == 0) {
        if (lockCount[0] == 0) {
            return "删除成功";
        } else {
            message.append("，其中").append(request.getIds().size()).append("条删除成功");
            //JXCPX-1935 可删除识别中、转化中数据
            /*if (noFinishRecCount > 0) {
                message.append("，").append(noFinishRecCount).append("条未获取识别结果不可删除");
            }*/
            if (lockCount[0] > 0) {
                message.append("，").append(lockCount[0]).append("条发票已锁定不可删除");
            }
        }
        return message.toString();
    }

}