package com.xforceplus.elephant.image.controller.image.process.insertbillimage;

import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import org.springframework.stereotype.Service;

/**
 * 重药补扫
 * @author rongying
 * @date 2022/2/10 9:44
 */
@Dispatch(tenantCode = "CQP")
@Service
public class CQPInsertBillImageProcess extends DefaultInsertBillImageProcess {

    /**
     * 重药定制逻辑，补扫发票取单据组织id
     * @author rongying
     * @date 2022/2/9 19:28
     * @param image 影像
     * @param billEntity 单据
     * @return void
     */
    @Override
    protected void setOrgId(Image image, BaseBill billEntity) {
        if (null == billEntity) {
            return;
        }
        if (null != billEntity.getOrgId()) {
            image.setOrgId(billEntity.getOrgId());
            image.setOrgCode(billEntity.getOrgCode());
            image.setOrgName(billEntity.getOrgName());
        }
    }

}