package com.xforceplus.elephant.image.controller.image.process.insertbillimage;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.help.FileUtils;
import com.xforceplus.elephant.basecommon.help.RandomUtil;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.InsertBillImageRequest;
import com.xforceplus.elephant.image.client.model.InsertImageDTO;
import com.xforceplus.elephant.image.core.business.application.collect.batch.domain.EnableFlowContext;
import com.xforceplus.elephant.image.core.business.application.collect.batch.service.BatchService;
import com.xforceplus.elephant.image.core.business.application.collect.task.domain.FileTransformTypeConfig;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.consts.Constants;
import com.xforceplus.elephant.image.core.business.enums.FileTypeEnum;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.business.persistence.AsyncTaskRepository;
import com.xforceplus.elephant.image.core.business.util.LogUtil;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.elephant.image.core.domain.config.ConfigSettingsService;
import com.xforceplus.elephant.image.core.domain.imagefile.ImageFileService;
import com.xforceplus.elephant.image.core.facade.application.collect.bill.BillFacade;
import com.xforceplus.elephant.image.core.facade.application.collect.upload.UploadFacade;
import com.xforceplus.elephant.image.core.facade.dto.upload.UploadImageDto;
import com.xforceplus.elephant.image.core.facade.dto.upload.UploadImageRequestDto;
import com.xforceplus.elephant.image.core.util.ImageUtils;
import com.xforceplus.elephant.image.listener.MqQueueSizeListener;
import com.xforceplus.elephant.image.mapper.UploadMapper;
import com.xforceplus.general.utils.GeneralUtil;
import com.xforceplus.purchaser.bizratelimiter.model.Application;
import com.xforceplus.purchaser.bizratelimiter.model.BizRequest;
import com.xforceplus.purchaser.bizratelimiter.model.Channel;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.SettlementType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.TransformScene;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.AsyncTask;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.ImageFile;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta.ConfigSettings;
import com.xforceplus.xlog.core.model.LogContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.groovy.util.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * @author yuhongxia
 * @description 补扫单据下的单证
 * @date 2021/5/8 17:06
 */
@Dispatch(isDefault = true)
@Service
public class DefaultInsertBillImageProcess extends AbstractProcess<InsertBillImageRequest, List<Long>> {

    @Autowired
    private BillFacade billFacade;
    @Autowired
    private ImageFileService imageFileService;
    @Autowired
    private UploadFacade uploadFacade;
    @Autowired
    private UploadMapper uploadMapper;
    @Autowired
    private ConfigSettingsService configSettingsService;
    @Autowired
    private BaseBillService baseBillService;
    @Autowired
    private BatchService batchService;
    @Autowired
    private AsyncTaskRepository asyncTaskRepository;
    @Autowired
    private MQUtils mqUtils;
    @Autowired(required = false)
    private Application application;

    @Value("${image.pdfQueue.threshold:1000}")
    private int pdfQueueSize;
    @Value("${image.pdfQueue.tpm:90}")
    private int pdfQueueTpm;
    @Value("${image.pdfQueue.tips:当前pdf转换队列已积压%s条，预估等到时间%s分钟}")
    private String pdfQueueTips;

    @Override
    protected void check(final InsertBillImageRequest request) throws ValidationException {
        checkEmpty(request.getBillCode(), "单据CODE不能为空");
        checkEmpty(request.getInsertImageDTOList(), "操作对象不能为空");
        for (final InsertImageDTO entity : request.getInsertImageDTOList()) {
            checkEmpty(entity.getFileStream(), "文件流不能为空");
            checkEmpty(entity.getFileType(), "文件类型不能为空");
            final FileTypeEnum fileTypeEnum = FileTypeEnum.fromCode(entity.getFileType());
            checkEmpty(fileTypeEnum, "不支持该类型文件" + entity.getFileType());
        }
    }

    @Override
    protected CommonResponse<List<Long>> process(final InsertBillImageRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        if (ValidatorUtil.isEmpty(user)) {
            return CommonResponse.failed("用户信息获取失败!");
        }
        LogUtil.attachBillCode(request.getBillCode());
        final BaseBill billEntity = billFacade.selectBaseBillByCode(user.getTenantId(), request.getBillCode(), EntityMeta.BaseBill.code());
        if (ValidatorUtil.isEmpty(billEntity)) {
            return CommonResponse.failed("上传失败,该单据不存在!");
        }
        if (!Arrays.asList(BillDataStatus._0.getCode(), BillDataStatus._2.getCode(), BillDataStatus._6.getCode(), BillDataStatus._4.getCode())
                   .contains(billEntity.getBillDataStatus())) {
            return CommonResponse.failed("单据非待提交/暂挂起/已提交/已退回状态不可补扫上传影像");
        }

        LogUtil.attachSaveCount(CollectionUtils.size(request.getInsertImageDTOList()));
        final String batchNo = System.currentTimeMillis() + String.valueOf(RandomUtil.randomInt(99999));
        final String[] isPublic = {ValidatorUtil.isNotEmpty(billEntity.getIsPublic()) ? billEntity.getIsPublic() : ""};
        if (ValidatorUtil.isNotEmpty(request.getIsPublic())) {
            isPublic[0] = request.getIsPublic();
        }
        //1-获取当前补扫影像
        final Image parentImage = uploadFacade.getInsertImage(user.getTenantId(), request.getParentImageId(), billEntity.getBillCode(), EntityMeta.Image.code());
        final String[] fileOrder = {""};
        if (parentImage != null) {
            fileOrder[0] = parentImage.getFileOrder();
            //1-2补扫更新父影像fileOrder
            uploadFacade.updateFileOrder(parentImage.getId(), fileOrder[0], request.getInsertImageDTOList().size(), EntityMeta.Image.code());
        }
        //2-获取文件转换字典配置
        final FileTransformTypeConfig fileTransformTypeConfig = imageFileService.getFileTransformTypeConfig(user.getTenantId());
        //3-上传
        final List<Long> imageIds = new ArrayList<>();
        final AtomicInteger index = new AtomicInteger();
        //3-0 存在zip，解析完在上传
        final UploadImageRequestDto requestDto = uploadMapper.map(request);
        uploadFacade.initSystemField(requestDto, user);
        final List<UploadImageDto> resultList = uploadFacade.checkZipFile(requestDto.getUploadImageDtoList(), user.getTenantId());
        final List<String> failedList = new ArrayList<>();//上传失败文件
        //是否开启限流
        final EnableFlowContext context = new EnableFlowContext().setTenantId(user.getTenantId()).setUserId(user.getId());
        final boolean flag = batchService.enable(context);
        final List<JSONObject> requestDtos = new ArrayList<>();
        resultList.forEach(imageDto -> {
            final String newFileOrder = request.getParentImageId() != null
                ? (fileOrder[0] + ImageUtils.sequence(index.incrementAndGet(), resultList.size()))
                : ImageUtils.sequence(billEntity.getImageCount() + index.incrementAndGet());
            //3-1初始化影像文件
            final ImageFile imageFile = uploadFacade.initImageFile(requestDto);
            imageFile.setTransformScene(TransformScene.TRANS_REC.getCode());
            //3-2获取影像上传地址,存储 fileKey,fileName
            final String fileUrl = uploadFacade.getUploadImageUrl(user.getTenantId(), user.getId(), imageDto.getFileStream(), imageDto.getFileType(), imageFile);
            if (ValidatorUtil.isEmpty(fileUrl)) {
                failedList.add(imageDto.getFileName() + imageDto.getFileType());
                return;
            }
            final String fileSuffix = ValidatorUtil.isNotEmpty(FileUtils.getFileSuffix(fileUrl)) ? FileUtils.getFileSuffix(fileUrl) : imageDto.getFileType();
            imageFile.setFileSuffix(fileSuffix);
            imageFile.setFileUrl(fileUrl);
            imageFile.setAttachmentName(imageDto.getFileName());
            imageFile.setFileOrder(newFileOrder);
            imageFile.setIsPublic(isPublic[0]);
            imageFile.setBatchNo(batchNo);
            imageFile.setBillEntityCode(billEntity.getBillTypeCode());
            //补扫发票单据code取值为：单据数据，碧桂园存在单号大小写问题
            imageFile.setBillCode(billEntity.getBillCode());

            //3-3初始化影像
            final Image image = uploadFacade.initImage(requestDto);
            image.setFileUrl(fileUrl);
            image.setFileUrlHandle(fileUrl);
            image.setFileType(fileSuffix);
            image.setFileTypeHandle(fileSuffix);
            image.setFileOrder(newFileOrder);
            image.setIsPublic(isPublic[0]);
            image.setBatchNo(batchNo);
            image.setFileName(imageDto.getFileName());
            image.setBillEntityCode(billEntity.getBillTypeCode());
            //补扫发票单据code取值为：单据数据，碧桂园存在单号大小写问题
            image.setBillCode(billEntity.getBillCode());
            image.setPurchaserTenantId(billEntity.getPurchaserTenantId());
            image.setPurchaserTenantCode(billEntity.getPurchaserTenantCode());
            //设置组织id值
            setOrgId(image, billEntity);
            //3-4上传
            if (!flag) {
                final Long imageId = uploadFacade.executeUpload(billEntity, fileSuffix, image, imageFile, fileTransformTypeConfig);
                if (ValidatorUtil.isNotEmpty(imageId)) {
                    imageIds.add(imageId);
                }
                return;
            }
            final JSONObject dto = new JSONObject();
            dto.put("image", image);
            dto.put("imageFile", imageFile);
            requestDtos.add(dto);
        });
        LogContext.setLogPoint("enableFlow", flag);
        if (flag) {
            final String channelCode = batchService.getChannelCode(user.getTenantCode());
            final int taskCount = resultList.size();
            final AsyncTask asyncTask = batchService.create(user, MQEnum.INSERT_BILL_UPLOAD_SYNC_QUEUE, taskCount, channelCode, request.getBillCode());
            final String batchId = asyncTask.getTaskNo();
            requestDtos.forEach(dto -> {
                ((Image) dto.get("image")).setBatchNo(String.valueOf(batchId));
                ((ImageFile) dto.get("imageFile")).setBatchNo(String.valueOf(batchId));
            });
            final Map<String, Object> headers = new HashMap<>();
            headers.put(com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE, user.getTenantCode());
            headers.put("batchNo", batchId);
            headers.put("asyncTaskId", asyncTask.getId());
            headers.put("userInfo", JSONObject.toJSONString(user));
            headers.put("channelCode", channelCode);
            headers.put(Constants.START_TIME, GeneralUtil.asTimestamp(asyncTask.getCreateTime()));
            headers.put("taskCount", taskCount);
            final JSONObject message = new JSONObject();
            message.put("bill", billEntity);
            message.put("images", requestDtos);
            try {
                if (batchService.sendEnableFlow(context)) {
                    final Channel channel = application.loadChannel(channelCode);
                    final BizRequest bizRequest = BizRequest.builder()
                                                            .bizQuantity(taskCount)
                                                            .properties(headers)
                                                            .body(message.toJSONString())
                                                            .attrs(Maps.of("queueName", MQEnum.INSERT_BILL_UPLOAD_SYNC_QUEUE))
                                                            .build();
                    channel.flowInRateLimit(bizRequest);
                } else {
                    mqUtils.sendByDirectExchange(MQEnum.INSERT_BILL_UPLOAD_SYNC_QUEUE, message.toJSONString(), headers);
                }
            } catch (Exception e) {
                LogContext.setLogPoint("enableFlowError", e.getMessage());
                logger.error("使用限流异常", e);
                LogContext.setLogPoint("error", String.format("使用限流异常:%s", e.getMessage()));
                mqUtils.sendByDirectExchange(MQEnum.INSERT_BILL_UPLOAD_SYNC_QUEUE, message.toJSONString(), headers);
            }

            return CommonResponse.ok("成功");
        }
        //AR单重算单据
        if (SettlementType.AR.getCode().equals(billEntity.getSettlementType())) {
            uploadFacade.reCheckBill(user.getTenantId(), user.getTenantCode(), billEntity.getBillCode(), "AR单上传重算单据");
        }
        //上传成功，则修改单据状态为待处理
        if (resultList.size() - failedList.size() > 0 && BillDataStatus.fromCode(billEntity.getBillDataStatus()) == BillDataStatus._6) {
            final JSONObject update = new JSONObject();
            update.put(EntityMeta.BaseBill.BILL_DATA_STATUS.code(), BillDataStatus._0.getCode());
            baseBillService.updateByBillIdSelective(billEntity.getId(), update);
        }

        if (ValidatorUtil.isNotEmpty(failedList)) {
            String message = String.format("共上传%d条，其中%d条上传成功，%d条上传失败", resultList.size(), resultList.size() - failedList.size(), failedList.size());
            logger.info("insertBillImage上传失败【{}】", failedList.stream().collect(Collectors.joining(",")));
            if (failedList.size() == resultList.size()) {
                message = "上传失败!";
            }
            return CommonResponse.ok(message);
        }
        final Integer queueSize = MqQueueSizeListener.QUEUE_SIZE.get(MQEnum.IMAGE_PDF_TRANSFORM_CALLBACK_QUEUE);
        if (resultList.stream().anyMatch(dto -> FileTypeEnum.PDF.getCode().equals(dto.getFileType()))
            && queueSize != null && queueSize > pdfQueueSize) {
            return CommonResponse.ok(String.format(pdfQueueTips, queueSize, queueSize / pdfQueueTpm + 1), imageIds);
        }

        return CommonResponse.ok("上传成功!", imageIds);
    }

    protected void setOrgId(final Image image, final BaseBill billEntity) {
        //jira-1572 租户是否开启非增票权限校验
        final String checkNVatPermissionValue = configSettingsService.select(billEntity.getTenantId(), ConfigSettings.IS_CHECK_N_VAT_PERMISSION.code(), String.class, YesNo._0.getCode());
        if (YesNo._1.getCode().equals(checkNVatPermissionValue)) {
            image.setOrgId(billEntity.getOrgId());
            image.setOrgCode(billEntity.getOrgCode());
            image.setOrgName(billEntity.getOrgName());
        }
    }

}
