package com.xforceplus.elephant.image.controller.image.process.saveimage;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.baseconst.SettingsConstants;
import com.xforceplus.elephant.basecommon.dispatch.BeanDispatcher;
import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.system.paas.NotificationUtils;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.ImageDTO;
import com.xforceplus.elephant.image.client.model.SaveImageRequest;
import com.xforceplus.elephant.image.common.ScanCommonService;
import com.xforceplus.elephant.image.core.business.application.collect.batch.domain.EnableFlowContext;
import com.xforceplus.elephant.image.core.business.application.collect.batch.service.BatchService;
import com.xforceplus.elephant.image.core.business.application.config.common.domain.CheckBillCodeExistConfig;
import com.xforceplus.elephant.image.core.business.application.config.common.enums.ReceiveFilterEnums;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.consts.Constants;
import com.xforceplus.elephant.image.core.business.enums.DictEnum;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.business.util.LogUtil;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.elephant.image.core.domain.config.ConfigDictionaryService;
import com.xforceplus.elephant.image.core.domain.config.ConfigSettingsService;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.elephant.image.core.facade.application.collect.upload.UploadFacade;
import com.xforceplus.elephant.image.core.facade.application.config.dictionary.extfields.ExtFieldsReceiveFacade;
import com.xforceplus.elephant.image.core.repository.model.BatchTaskEntity;
import com.xforceplus.purchaser.bizratelimiter.model.Application;
import com.xforceplus.purchaser.bizratelimiter.model.BizRequest;
import com.xforceplus.purchaser.bizratelimiter.model.Channel;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ExceptionStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageCategory;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.RecStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.xlog.core.model.LogContext;
import io.vavr.Tuple2;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.groovy.util.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Dispatch(isDefault = true)
@Service
public class DefaultSaveImageProcess extends AbstractProcess<SaveImageRequest, List<Long>> {

    protected static final String REPEAT_BILL = "[REPEAT_BILL]";
    protected ThreadLocal<List<Tuple2<Integer, String>>> billFilter = new ThreadLocal<>();
    @Autowired
    protected ImageService imageService;
    @Autowired
    protected BaseBillService baseBillService;
    @Autowired
    protected NotificationUtils notificationUtils;
    @Autowired
    protected ConfigSettingsService configSettingsService;
    @Autowired
    protected ConfigDictionaryService configDictionaryService;
    @Autowired
    protected BillImageTicketService billImageTicketService;
    @Autowired
    protected MQUtils rabbitmqUtils;
    @Autowired
    protected BeanDispatcher beanDispatcher;
    @Autowired
    protected ExtFieldsReceiveFacade extFieldsReceiveFacade;
    @Autowired
    private UploadFacade uploadFacade;
    @Autowired
    private BatchService batchService;
    @Autowired
    private ScanCommonService scanCommonService;
    @Autowired(required = false)
    private Application application;

    @Override
    protected void check(final SaveImageRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getEntities())) {
            throw new ValidationException("操作对象不能为空");
        }
        for (final ImageDTO entity : request.getEntities()) {
            checkEmpty(entity.getImageCategory(), "影像目录不能为空");
            checkEmpty(entity.getImageSource(), "来源不能为空");
            checkEmpty(entity.getFileUrl(), "原始文件路径不能为空");
            checkEmpty(entity.getFileUrlHandle(), "处理文件路径不能为空");
            checkEmpty(entity.getFileType(), "原始文件类型不能为空");
            checkEmpty(entity.getFileTypeHandle(), "处理文件类型不能为空");
            checkEmpty(entity.getIsPublic(), "是否公共上传不能为空");
        }
    }

    @Override
    protected CommonResponse<List<Long>> process(final SaveImageRequest request) throws RuntimeException {
        if (billFilter.get() == null) {
            billFilter.set(new ArrayList<>());
        }
        try {
            final IAuthorizedUser user = UserInfoHolder.get();
            final long billCount = request.getEntities().stream()
                                          .filter(dto -> ValidatorUtil.isNotEmpty(dto.getBillCode()))
                                          .count();

            //个人单证池上传封面强转附件
            request.getEntities().forEach(entity -> {
                if (!YesNo._1.getCode().equals(entity.getIsPublic())
                    && ValidatorUtil.isNotEmpty(entity.getBillCode())) {
                    entity.setBillCode(StringUtils.EMPTY);
                    entity.setImageType(ImageType._99.getCode());
                    entity.setImageCategory(ImageCategory._5.getCode());
                }
            });

            final Map<String, List<ImageDTO>> dtoMap = filter(request);

            final String batchNo = Long.toString(System.currentTimeMillis());
            final List<JSONObject> images = new ArrayList<>();
            dtoMap.values().forEach(dtos -> dtos.forEach(dto -> {
                final Image entity = Image.fromOQSMap(BeanUtils.convertJSON(dto));
                entity.setBatchNo(batchNo);
                entity.setFileOrder("");
                entity.setTenantId(user.getTenantId());
                entity.setTenantCode(user.getTenantCode());
                entity.setStatus(ImageStatus._1.getCode());
                entity.setIsManualUnhook(YesNo._0.getCode());
                entity.setExceptionStatus(ExceptionStatus._0.getCode());
                entity.setReturnStatus(BackType._0.getCode());
                entity.setFileUrlLocal(StringUtils.EMPTY);
                entity.setCreateUserCode(user.getUserCode());
                entity.setCreateUserId(user.getId());
                entity.setCreateUserName(user.getUsername());
                entity.setCreateTime(LocalDateTime.now());
                if (StringUtils.isNotBlank(request.getSerialNumber())) {
                    entity.setSerialNumber(request.getSerialNumber());
                }
                // 此处不可放开，否则会导致影像单据创建失败 （数据内层已有billEntityCode，取的页面的tabCode，外层的前端有业务逻辑，不是tabCode）
                /*if (StringUtils.isNotBlank(request.getBillEntityCode())) {
                    entity.setBillEntityCode(request.getBillEntityCode());
                }*/
                //处理扩展字段
                final JSONObject json = new JSONObject(entity.toOQSMap());
                if (ValidatorUtil.isNotEmpty(request.getExt())) {
                    final JSONObject ticketPreData = new JSONObject(request.getExt());
                    ticketPreData.remove(EntityMeta.Image.ID.code());
                    ticketPreData.remove("token");
                    final JSONObject area = ObjectUtils.firstNonNull(request.getExt().getJSONObject("area"), request.getExt().getJSONObject("areas"));
                    if (ValidatorUtil.isNotEmpty(area)) {
                        ticketPreData.put(EntityMeta.Ticket.AREAS_ID.code(), area.get("orgId"));
                        ticketPreData.put(EntityMeta.Ticket.AREA_ID.code(), area.get("orgId"));
                        ticketPreData.put(EntityMeta.Ticket.AREA_CODE.code(), area.get("orgCode"));
                        ticketPreData.put(EntityMeta.Ticket.AREA_NAME.code(), area.get("orgName"));
                    }
                    ticketPreData.remove("area");
                    ticketPreData.remove("areas");
                    json.put(EntityMeta.Image.TICKET_PRE_DATA.code(), ticketPreData.toJSONString());
                    json.putAll(extFieldsReceiveFacade.getExtFields(user.getTenantId(), ReceiveFilterEnums.IMAGE, request.getExt()));
                }
                images.add(json);
            }));
            final String message = message(billCount);
            final EnableFlowContext context = new EnableFlowContext().setTenantId(user.getTenantId()).setUserId(user.getId());
            final boolean flag = CollectionUtils.isNotEmpty(images) && batchService.enable(context);
            LogContext.setLogPoint("enableFlow", flag);
            LogUtil.attachSaveCount(CollectionUtils.size(request.getEntities()));
            if (flag) {
                final String channelCode = batchService.getChannelCode(user.getTenantCode());
                final BatchTaskEntity batchTaskEntity = new BatchTaskEntity();
                batchTaskEntity.setTenantId(user.getTenantId());
                batchTaskEntity.setTenantCode(user.getTenantCode());
                batchTaskEntity.setCreateUserId(user.getId());
                batchTaskEntity.setCreateUserName(user.getUsername());
                batchTaskEntity.setCreateTime(new Date());
                batchTaskEntity.setTaskCount(request.getEntities().size());
                batchTaskEntity.setChannelCode(channelCode);
                final Long batchId = batchService.insert(batchTaskEntity);
                images.forEach(image -> image.put(EntityMeta.Image.BATCH_NO.code(), batchId));
                final Map<String, Object> headers = new HashMap<>();
                headers.put(com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE, user.getTenantCode());
                headers.put("batchNo", batchId);
                headers.put("userInfo", JSONObject.toJSONString(user));
                headers.put("channelCode", channelCode);
                headers.put(Constants.START_TIME, System.currentTimeMillis());
                try {
                    if (batchService.sendEnableFlow(context)) {
                        final Channel channel = application.loadChannel(channelCode);
                        final BizRequest bizRequest = BizRequest.builder()
                                                                .bizQuantity(batchTaskEntity.getTaskCount())
                                                                .properties(headers)
                                                                .body(JSONObject.toJSONString(images))
                                                                .attrs(Maps.of("queueName", MQEnum.SAVE_IMAGE_SYNC_QUEUE))
                                                                .build();
                        channel.flowInRateLimit(bizRequest);
                    } else {
                        rabbitmqUtils.sendByDirectExchange(MQEnum.SAVE_IMAGE_SYNC_QUEUE, JSONObject.toJSONString(images), headers);
                    }
                } catch (Exception e) {
                    LogContext.setLogPoint("enableFlowError", e.getMessage());
                    logger.error("使用限流异常", e);
                    LogContext.setLogPoint("error", String.format("使用限流异常:%s", e.getMessage()));
                    rabbitmqUtils.sendByDirectExchange(MQEnum.SAVE_IMAGE_SYNC_QUEUE, JSONObject.toJSONString(images), headers);
                }
                if (StringUtils.isNotBlank(message)) {
                    return CommonResponse.failed(message);
                }
                return CommonResponse.ok("成功");
            }
            final List<Long> imageIds = scanCommonService.saveImage(images);
            if (StringUtils.isNotBlank(message)) {
                return CommonResponse.from(CommonResponse.Fail, message, imageIds);
            }

            return CommonResponse.ok("成功", imageIds);
        } finally {
            billFilter.remove();
        }
    }

    /**
     * 过滤项
     *
     * @param dtoMap  单据dtoMap
     * @param billMap 单据Map
     */
    protected void filter(final Map<String, List<ImageDTO>> dtoMap, final Map<String, BaseBill> billMap) {
        //封面过滤
        billFilter.get().add(coverFilter(dtoMap, billMap));
        //根据租户配置单据号是否已存在过滤
        billFilter.get().add(checkBillCodeFilter(dtoMap, billMap));
    }

    /**
     * 过滤影像
     *
     * @param request 请求
     * @return
     */
    private Map<String, List<ImageDTO>> filter(final SaveImageRequest request) {
        //按单据封装请求
        final Map<String, List<ImageDTO>> dtoMap = wrapperData(request.getEntities());
        //查询已有单据
        final Map<String, BaseBill> billMap = wrapperData(dtoMap);
        //个人单证池不过滤
        final String isPublic = request.getEntities().get(0).getIsPublic();
        if (!YesNo._1.getCode().equals(isPublic)) {
            return dtoMap;
        }
        //前置过滤
        beforeFilter(dtoMap, billMap);
        //过滤
        filter(dtoMap, billMap);
        //后置过滤
        afterFilter(dtoMap, billMap);
        //如果单据已存在，则将新影像追加至最后
        final IAuthorizedUser user = UserInfoHolder.get();
        dtoMap.forEach((billCode, dtoList) -> {
            if (!billMap.containsKey(billCode)) {
                return;
            }
            final Image parentImage = uploadFacade.getInsertImage(user.getTenantId(), null, billCode, EntityMeta.Image.code());
            if (parentImage == null || StringUtils.isBlank(parentImage.getFileOrder())) {
                return;
            }
            final AtomicInteger index = new AtomicInteger();
            dtoList.forEach(dto -> dto.setFileOrder(parentImage.getFileOrder() + sequence(index.getAndIncrement(), dtoList.size())));
            dtoList.stream().findFirst().ifPresent(dto -> dto.setFileOrder("0"));
        });
        return dtoMap;
    }

    private String sequence(final int index, final int size) {
        final int digits = (int) Math.log10(size) + 1;
        final DecimalFormat format = new DecimalFormat(StringUtils.repeat("0", digits));
        return format.format(index);
    }

    /**
     * 将同一单据下影像归类
     *
     * @param entities entities
     * @return
     */
    protected Map<String, List<ImageDTO>> wrapperData(final List<ImageDTO> entities) {
        final Map<String, List<ImageDTO>> dtoMap = new LinkedHashMap<>();
        String billCode = StringUtils.EMPTY;
        final String regexSplit = configSettingsService.select(UserInfoHolder.get().getTenantId(), SettingsConstants.BILL_CODE_REGEX_SPLIT);
        for (final ImageDTO entity : entities) {
            if (ValidatorUtil.isNotEmpty(entity.getBillCode())) {
                billCode = entity.getBillCode();
                entity.setImageType(ImageType._1.getCode());
                entity.setRequireOcrFlag(YesNo._0.getCode());
                entity.setRecStatus(RecStatus._2.getCode());
                if (ValidatorUtil.isNotEmpty(regexSplit)) {
                    for (final String reg : regexSplit.split(",")) {
                        final Pattern pattern = Pattern.compile(reg);
                        final Matcher matcher = pattern.matcher(billCode);
                        if (matcher.find()) {
                            billCode = matcher.group(1);
                            break;
                        }
                    }
                }
                if (dtoMap.containsKey(billCode)) {
                    billCode += REPEAT_BILL;
                }
            } else {
                entity.setRequireOcrFlag(YesNo._1.getCode());
                entity.setRecStatus(RecStatus._0.getCode());
            }
            if (!dtoMap.containsKey(billCode)) {
                dtoMap.put(billCode, new ArrayList<>());
            }
            dtoMap.get(billCode).add(entity);
            entity.setBillCode(billCode);
        }
        return dtoMap;
    }

    /**
     * 根据单据号查询单据，如果有的话
     *
     * @param dtoMap 单据dtoMap
     * @return
     */
    protected Map<String, BaseBill> wrapperData(final Map<String, List<ImageDTO>> dtoMap) {
        final List<String> billCodes = dtoMap.keySet().stream()
                                             .filter(billCode -> ValidatorUtil.isNotEmpty(billCode))
                                             .collect(Collectors.toList());
        if (ValidatorUtil.isEmpty(billCodes)) {
            return new HashMap<>();
        }
        final Map<String, BaseBill> billMap = new HashMap<>();
        final long tenantId = UserInfoHolder.get().getTenantId();
        baseBillService.selectBillDataByBillCodes(tenantId, billCodes)
                       .forEach(bill -> billMap.put(bill.getBillCode(), bill));
        return billMap;
    }

    /**
     * 前置过滤项
     *
     * @param dtoMap  单据dtoMap
     * @param billMap 单据Map
     */
    private void beforeFilter(final Map<String, List<ImageDTO>> dtoMap, final Map<String, BaseBill> billMap) {
        //重复扫描过滤
        final StringBuilder sb = new StringBuilder();
        final List<String> billCodes = dtoMap.keySet().stream()
                                             .filter(code -> ValidatorUtil.isNotEmpty(code))
                                             .filter(code -> code.contains(REPEAT_BILL))
                                             .collect(Collectors.toList());
        billCodes.forEach(code -> {
            final String repeatBillCode = code.replace(REPEAT_BILL, "");
            sb.append(billCodeName()).append(repeatBillCode)
              .append("挂接了").append(dtoMap.remove(code).size())
              .append("张影像，与同批次扫描的单据重复;\n");
        });
        if (billCodes.size() > 0) {
            billFilter.get().add(new Tuple2<>(billCodes.size(), sb.toString()));
        }
    }

    /**
     * 封面过滤
     *
     * @param dtoMap  单据dtoMap
     * @param billMap 单据Map
     * @return
     */
    private Tuple2<Integer, String> coverFilter(final Map<String, List<ImageDTO>> dtoMap, final Map<String, BaseBill> billMap) {
        //没有缺封面的，直接跳过
        if (!dtoMap.containsKey(StringUtils.EMPTY)) {
            return new Tuple2<>(0, "");
        }
        final int count = dtoMap.remove(StringUtils.EMPTY).size();
        if (count > 0) {
            return new Tuple2<>(0, String.format("共有%s张无封面的影像，不可上传，请检查是否有封面;\n", count));
        }
        return new Tuple2<>(0, "");
    }

    private Tuple2<Integer, String> checkBillCodeFilter(final Map<String, List<ImageDTO>> dtoMap, final Map<String, BaseBill> billMap) {
        //租户单据是否已存在过滤项，没有配置，则跳过
        final String config = configDictionaryService.select(UserInfoHolder.get().getTenantId(), DictEnum.CHECK_BILL_CODE_EXIST_CONFIG.getCode());
        if (ValidatorUtil.isEmpty(config)) {
            return new Tuple2<>(0, "");
        }
        final CheckBillCodeExistConfig configDetail = JSONObject.parseObject(config, CheckBillCodeExistConfig.class);
        if (Objects.isNull(configDetail) || !configDetail.isEnable()) {
            return new Tuple2<>(0, "");
        }
        final Set<String> newBillCodes = dtoMap.keySet();
        final Set<String> existBillCodes = billMap.keySet();
        int notExistCount = 0;
        for (final String billCode : newBillCodes) {
            if (!existBillCodes.contains(billCode)) {
                notExistCount = notExistCount + 1;
                dtoMap.remove(billCode);
            }
        }
        if (notExistCount > 0) {
            return new Tuple2<>(notExistCount, "单据未推送至影像系统，请联系贵司IT。");
        }
        return new Tuple2<>(0, "");
    }

    /**
     * 后置过滤项
     *
     * @param dtoMap  单据dtoMap
     * @param billMap 单据Map
     */
    private void afterFilter(final Map<String, List<ImageDTO>> dtoMap, final Map<String, BaseBill> billMap) {
        //重复单据过滤
        billFilter.get().add(repeatFilter(dtoMap, billMap));
    }

    /**
     * 重复过滤
     *
     * @param dtoMap  单据dtoMap
     * @param billMap 单据Map
     * @return
     */
    private Tuple2<Integer, String> repeatFilter(final Map<String, List<ImageDTO>> dtoMap, final Map<String, BaseBill> billMap) {
        if (ValidatorUtil.isEmpty(billMap)) {
            return new Tuple2<>(0, "");
        }
        final List<String> billCodes = billMap.entrySet().stream().filter(entry ->
                                                  !Arrays.asList(BillDataStatus._0.getCode(), BillDataStatus._2.getCode()).contains(entry.getValue().getBillDataStatus())
                                              ).map(entry -> entry.getKey())
                                              .collect(Collectors.toList());
        if (ValidatorUtil.isEmpty(billCodes)) {
            return new Tuple2<>(0, "");
        }
        final StringBuilder sb = new StringBuilder();
        //单据号JW131903292，挂接单证10张,
        //与[扫描批次: 19-1203-0987, 扫描人:张三]重复
        //单据号XXXXX在[扫描时间：xxxx:xx:xx]被[扫描人：XXX]采集过，请勿重复采集
        billCodes.forEach(billCode -> {
            final BaseBill billEntity = billMap.get(billCode);
            if (BillDataStatus._5.getCode().equals(billEntity.getBillDataStatus())) {
                sb.append(billCodeName()).append(billCode)
                  .append("已作废，不允许采集。\n");
            } else {
                sb.append(billCodeName()).append(billCode)
                  .append("在[扫描时间：").append(DateUtil.format(Date.from(billEntity.getScanCreateTime().toInstant(ZoneOffset.ofHours(8))), "yyyy-MM-dd HH:mm:ss"))
                  .append("]被[扫描人：").append(billEntity.getScanUserName())
                  .append("]采集过，请勿重复采集;\n");
            }

            billMap.remove(billCode);
            dtoMap.remove(billCode);
        });
        return new Tuple2<>(billCodes.size(), sb.toString());
    }

    /**
     * 单据号 or 流程号 or 其他。。
     *
     * @return
     */
    protected String billCodeName() {
        return "单据号";
    }

    /**
     * 过滤消息整理
     *
     * @param billCount billCount
     * @return
     */
    private String message(final long billCount) {
        int count = 0;
        final StringBuilder sb = new StringBuilder();
        for (final Tuple2<Integer, String> filter : billFilter.get()) {
            count += filter._1;
            sb.append(filter._2);
        }
        final StringBuilder message = new StringBuilder();
        if (count > 0 || sb.length() > 0) {
            final String title = "影像上传提醒";
            message.append("本批次共扫描单据").append(billCount).append("份");
            if (count > 0) {
                message.append("，其中单据异常").append(count).append("份");
            }
            message.append("：\n").append(sb);
            notificationUtils.sendSingleMessage(UserInfoHolder.get().getTenantId(),
                Collections.singletonList(UserInfoHolder.get().getId()), title, message.toString());
        }
        return message.toString();
    }

}