package com.xforceplus.elephant.image.controller.image.process.unhook;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.BillSelectAllRequest;
import com.xforceplus.elephant.image.core.business.enums.ResourceEnum;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.elephant.image.core.domain.config.ConfigSettingsService;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.domain.image.bean.ImageSearchBean;
import com.xforceplus.elephant.image.core.domain.ticket.TicketService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.elephant.image.core.facade.application.auth.DataResourceFacade;
import com.xforceplus.elephant.image.core.facade.application.collect.image.ImageFacade;
import com.xforceplus.elephant.image.mapper.ImageSearchMapper;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.RecStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Dispatch(isDefault = true)
@Service
public class DefaultUnhookImageProcess extends AbstractProcess<BillSelectAllRequest, Boolean> {

    @Autowired
    private ImageService imageService;
    @Autowired
    private BillImageTicketService billImageTicketService;
    @Autowired
    private ImageFacade imageFacade;
    @Autowired
    private ImageSearchMapper mapper;
    @Autowired
    private BaseBillService baseBillService;
    @Autowired
    private DataResourceFacade dataResourceFacade;
    @Autowired
    private ConfigSettingsService configSettingsService;
    @Autowired
    private TicketService ticketService;

    @Override
    protected void check(final BillSelectAllRequest request) throws ValidationException {
        super.check(request);
        if (request.isAllSelected()) {
            checkEmpty(request.getBillCode(), "单据code不能为空");
        }
        if (!request.isAllSelected()) {
            checkEmpty(request.getIncluded(), "影像id不能为空");
        }
    }

    protected String filter(final BillSelectAllRequest request) {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        final List<Image> images = imageService.selectImages(authorizedUser.getTenantId(), request.getIds());
        final long count = images.stream()
            .filter(entity -> !Arrays.asList(RecStatus._2.getCode(), RecStatus._3.getCode()).contains(String.valueOf(entity.getRecStatus())))
            .map(entity -> request.getIds().remove(entity.getId()))
            .count();
        if (count > 0) {
            return String.format("共勾选%d条，其中%d条脱挂成功，%d条未获取识别结果不可脱挂", images.size(),
                images.size() - count, count);
        }
        return "成功";
    }

    /**
     * 准备要操作的数据 格式化全选反选数据到ids 需要注意此处是要考虑全选操作是带着筛选条件的
     *
     * @param request 请求
     * @return void
     * @author liming
     * @date 2021/7/30 11:18
     */
    private void prepareOperateData(final BillSelectAllRequest request) {
        //全选
        final IAuthorizedUser user = UserInfoHolder.get();
        if (request.isAllSelected()) {
            //条件筛选
            final ImageSearchBean searchBean = mapper.map(request);
            searchBean.setTenantId(user.getTenantId());
            final List<Image> imageList = imageFacade.selectBillImagesByCustomTicketParams(searchBean, EntityMeta.Image.code()).getRows();
            final List<Long> ids = imageList.stream()
                .filter(image -> !ImageType._1.getCode().equals(image.getImageType()))
                .map(image -> image.getId())
                .collect(Collectors.toList());
            if (ValidatorUtil.isNotEmpty(request.getExcluded())) {
                final List<Long> excludedList = request.getExcluded().stream().map(s -> Long.parseLong(s)).collect(Collectors.toList());
                ids.removeAll(excludedList);
            }
            request.setIds(ids);
        }
        //非全选
        if (!request.isAllSelected()) {
            final List<Long> ids = request.getIncluded().stream().map(s -> Long.parseLong(s)).collect(Collectors.toList());
            request.setIds(ids);
        }
    }

    @Override
    protected CommonResponse<Boolean> process(final BillSelectAllRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        prepareOperateData(request);

        BaseBill billEntity = new BaseBill();
        //数据权限过滤
        if (ValidatorUtil.isNotEmpty(request.getBillCode())) {
            billEntity = baseBillService.selectBaseBillByCode(authorizedUser.getTenantId(), request.getBillCode());
            if (billEntity != null && Arrays.asList(BillDataStatus._3.getCode(), BillDataStatus._1.getCode()).contains(billEntity.getBillDataStatus())) {
                throw new ValidationException("单据已锁定/已完成状态不可脱挂影像");
            }
            if (!dataResourceFacade.existBillDetailResourceAuth(authorizedUser.getTenantId(), request.getPageCode(), request.getScene(), billEntity, ResourceEnum.BILL_DETAILS_UNHOOK.getCode())) {
                throw new ValidationException("没有操作权限");
            }
        }

        final String message = filter(request);
        final String isMultipurposeTicket = configSettingsService.select(authorizedUser.getTenantId(),
            EntityMeta.ConfigSettings.IS_MULTIPURPOSE_TICKET.code(), String.class, YesNo._0.getCode());
        boolean result = false;
        if (YesNo._0.getCode().equals(isMultipurposeTicket)) {
            result = billImageTicketService.unhookImages(authorizedUser.getTenantId(), request.getBillCode(), request.getIds());
        } else {
            final List<Map<String, Object>> ticketList = ticketService.selectTicketByImageIds(authorizedUser.getTenantId(), request.getIds());
            final List<Map<String, Object>> exceptionList = ticketList.stream()
                .filter(ticket -> YesNo._1.getCode().toString().equals(ticket.get(EntityMeta.Ticket.EXCEPTION_STATUS.code()))).collect(Collectors.toList());
            if (ValidatorUtil.isNotEmpty(exceptionList)) {
                return CommonResponse.failed("发票校验异常，不可将发票释放到个人单证池，请删除当前采集发票");
            }
            result = billImageTicketService.unhookImages(authorizedUser.getTenantId(), request.getBillCode(), request.getIds());
            /*
            result = billImageTicketService.unhookRepeatImages(authorizedUser.getTenantId(), request.getBillCode(), request.getIds());
            */
        }
        if (result) {
            billImageTicketService.resetLevel(authorizedUser.getTenantId(), request.getBillCode());
            //修改单据状态为待处理
            if (BillDataStatus.fromCode(billEntity.getBillDataStatus()) == BillDataStatus._6) {
                final JSONObject updater = new JSONObject();
                updater.put(EntityMeta.BaseBill.BILL_DATA_STATUS.code(), BillDataStatus._0.getCode());
                baseBillService.updateByBillIdSelective(billEntity.getId(), updater);
            }
            return CommonResponse.ok(message, result);
        }
        return CommonResponse.failed(message);
    }

}