package com.xforceplus.elephant.image.controller.imagecopy.process;

import com.xforceplus.elephant.basecommon.process.AbstractKeyProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.core.domain.image.ImageCopyService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeleteImageCopyProcess extends AbstractKeyProcess<Long, BaseRequest, Boolean> {

    @Autowired
    private ImageCopyService imageCopyService;

    @Override
    protected CommonResponse<Boolean> process(Long imageCopyId, BaseRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        final boolean result = imageCopyService.deleteImageCopies(authorizedUser.getTenantId(), Arrays.asList(imageCopyId));
        if (result) {
            return CommonResponse.ok("删除成功", true);
        } else {
            return CommonResponse.failed("无记录删除");
        }
    }

}