package com.xforceplus.elephant.image.controller.imagereturn;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.ImageReturnApi;
import com.xforceplus.elephant.image.client.model.GetImageReturnLogListRequest;
import com.xforceplus.elephant.image.client.model.ImageReturnDTO;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.imagereturn.process.GetImageReturnLogListProcess;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 版权：    上海云砺信息科技有限公司 创建者: 创建时间: 功能描述: 修改历史:
 */
@ApiV1Image
public class ImageReturnController extends BaseController implements ImageReturnApi {

    @Autowired
    private GetImageReturnLogListProcess getImageReturnLogListProcess;

    @Override
    public CommonResponse<List<ImageReturnDTO>> getImageReturnList(GetImageReturnLogListRequest request) {
        return getImageReturnLogListProcess.execute(request);
    }

}