package com.xforceplus.elephant.image.controller.label;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.LabelApi;
import com.xforceplus.elephant.image.client.model.GetLabelListRequest;
import com.xforceplus.elephant.image.client.model.SaveLabelRequest;
import com.xforceplus.elephant.image.client.model.UpdateLabelStatusRequest;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.label.process.GetLabelListProcess;
import com.xforceplus.elephant.image.controller.label.process.SaveLabelProcess;
import com.xforceplus.elephant.image.controller.label.process.UpdateLabelStatusProcess;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 版权：    上海云砺信息科技有限公司 创建者: 创建时间: 功能描述: 修改历史:
 */
@ApiV1Image
public class LabelController extends BaseController implements LabelApi {

    @Autowired
    private SaveLabelProcess saveLabelProcess;
    @Autowired
    private GetLabelListProcess getLabelListProcess;
    @Autowired
    private UpdateLabelStatusProcess updateLabelStatusProcess;

    @Override
    public CommonResponse<List<Long>> saveLabel(@RequestBody SaveLabelRequest request) {
        return saveLabelProcess.execute(request);
    }

    @Override
    public CommonResponse getLabelList(@Valid GetLabelListRequest request) {
        return getLabelListProcess.execute(request);
    }

    @Override
    public CommonResponse updateLabelStatus(@RequestBody UpdateLabelStatusRequest request) {
        return updateLabelStatusProcess.execute(request);
    }

}