package com.xforceplus.elephant.image.controller.label.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.UpdateLabelStatusRequest;
import com.xforceplus.elephant.image.core.domain.label.LabelService;
import com.xforceplus.elephant.image.core.repository.model.LabelEntity;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UpdateLabelStatusProcess extends AbstractProcess<UpdateLabelStatusRequest, Boolean> {

    @Autowired
    private LabelService labelService;

    @Override
    protected void check(UpdateLabelStatusRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getLabelIds())) {
            throw new ValidationException("标签ID集合【labelIds】不能为空");
        }
        if (ValidatorUtil.isEmpty(request.getEnable())) {
            throw new ValidationException("标签状态【enable】不能为空");
        }
        if (!YesNo._1.getCode().equals(request.getEnable()) && !YesNo._0.getCode().equals(request.getEnable())) {
            throw new ValidationException("标签状态【enable】传参不合法：0-禁用，1-启用");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(UpdateLabelStatusRequest request) throws RuntimeException {
        final List<LabelEntity> labelEntities = labelService.selectLabelDataList(request.getLabelIds());
        if (CollectionUtils.isEmpty(labelEntities)) {
            return CommonResponse.failed("没有找到可操作的标签数据");
        }
        labelService.updateLabelStatusByIds(request.getLabelIds(), request.getEnable());
        return CommonResponse.ok("修改成功");
    }

}