package com.xforceplus.elephant.image.controller.logapi;

import com.xforceplus.elephant.basecommon.annotation.RedisLockMD5;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.process.response.ListResult;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.LogApiApi;
import com.xforceplus.elephant.image.client.model.GetLogApiListRequest;
import com.xforceplus.elephant.image.client.model.GetMethodCodeRequest;
import com.xforceplus.elephant.image.client.model.LogApiDTO;
import com.xforceplus.elephant.image.client.model.RetryLogApiRequest;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.logapi.process.GetLogApiDetailProcess;
import com.xforceplus.elephant.image.controller.logapi.process.GetLogApiListProcess;
import com.xforceplus.elephant.image.controller.logapi.process.GetMethodCodeProcess;
import com.xforceplus.elephant.image.controller.logapi.process.LogApiRetryProcess;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 版权：    上海云砺信息科技有限公司 创建者: 创建时间: 功能描述: 修改历史:
 */
@ApiV1Image
public class LogApiController extends BaseController implements LogApiApi {

    @Autowired
    private GetLogApiDetailProcess getLogApiDetailProcess;
    @Autowired
    private GetLogApiListProcess getLogApiListProcess;
    @Autowired
    private LogApiRetryProcess logApiRetryProcess;
    @Autowired
    private GetMethodCodeProcess getMethodCodeProcess;

    @Override
    public CommonResponse<LogApiDTO> getLogApiDetail(@PathVariable("logId") Long logId, BaseRequest request) {
        return getLogApiDetailProcess.execute(logId, request);
    }

    @Override
    public CommonResponse<ListResult<LogApiDTO>> getLogApiList(GetLogApiListRequest request) {
        return getLogApiListProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse logApiRetry(@RequestBody RetryLogApiRequest request) {
        return logApiRetryProcess.execute(request);
    }

    @Override
    public CommonResponse<String> getMethodCode(@Valid GetMethodCodeRequest request) {
        return getMethodCodeProcess.execute(request);
    }

}