package com.xforceplus.elephant.image.controller.logapi.process;

import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.process.response.ListResult;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.GetLogApiListRequest;
import com.xforceplus.elephant.image.client.model.LogApiDTO;
import com.xforceplus.elephant.image.core.repository.dao.LogApiDao;
import com.xforceplus.elephant.image.core.repository.model.LogApiExample;
import java.util.Date;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetLogApiListProcess extends AbstractProcess<GetLogApiListRequest, ListResult<LogApiDTO>> {

    @Autowired
    private LogApiDao logApiDao;

    @Override
    protected CommonResponse<ListResult<LogApiDTO>> process(GetLogApiListRequest request) throws RuntimeException {
        final LogApiExample logApiExample = new LogApiExample();
        final LogApiExample.Criteria criteria = logApiExample.createCriteria();
        logApiExample.setLimit(request.getRows());
        logApiExample.setOffset(request.getOffset());
        logApiExample.setOrderByClause("create_time desc");
        if (ValidatorUtil.isNotEmpty(request.getNumber())) {
            criteria.andNumberEqualTo(request.getNumber());
        }
        if (ValidatorUtil.isNotEmpty(request.getMethodCode())) {
            criteria.andMethodCodeEqualTo(request.getMethodCode());
        }
        if (ValidatorUtil.isNotEmpty(request.getMethodName())) {
            criteria.andMethodNameEqualTo(request.getMethodName());
        }
        if (ValidatorUtil.isNotEmpty(request.getSender())) {
            criteria.andSenderEqualTo(request.getSender());
        }
        if (ValidatorUtil.isNotEmpty(request.getReceiver())) {
            criteria.andReceiverEqualTo(request.getReceiver());
        }
        if (ValidatorUtil.isNotEmpty(request.getIsSuccess())) {
            criteria.andIsSuccessEqualTo(request.getIsSuccess());
        }
        if (ValidatorUtil.isNotEmpty(request.getInvoiceCode())) {
            criteria.andInvoiceCodeEqualTo(request.getInvoiceCode());
        }
        if (ValidatorUtil.isNotEmpty(request.getInvoiceNo())) {
            criteria.andInvoiceNoEqualTo(request.getInvoiceNo());
        }
        if (ValidatorUtil.isNotEmpty(request.getBillCode())) {
            criteria.andBillCodeEqualTo(request.getBillCode());
        }
        if (ValidatorUtil.isNotEmpty(request.getSystemType())) {
            criteria.andSystemTypeEqualTo(request.getSystemType());
        }
        if (ValidatorUtil.isNotEmpty(request.getIsSuccessful())) {
            criteria.andIsSuccessfulEqualTo(request.getIsSuccessful());
        }
        if (ValidatorUtil.isNotEmpty(request.getCreateTime()) && request.getCreateTime().size() == 2) {
            criteria.andCreateTimeBetween(
                new Date(request.getCreateTime().get(0)),
                new Date(request.getCreateTime().get(1)));
        }
        final ListResult<LogApiDTO> result = new ListResult(
            logApiDao.countByExample(logApiExample),
            logApiDao.selectByExample(logApiExample).stream().map(entity -> {
                final LogApiDTO dto = new LogApiDTO();
                BeanUtils.copyProperties(entity, dto);
                return dto;
            }).collect(Collectors.toList()));
        return CommonResponse.ok("成功", result);
    }

}