package com.xforceplus.elephant.image.controller.logapi.process;

import com.alibaba.fastjson.JSON;
import com.xforceplus.elephant.basecommon.enums.log.SystemTypeEnum;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.system.paas.PaasTokenUtils;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.RetryLogApiRequest;
import com.xforceplus.elephant.image.core.domain.log.LogService;
import com.xforceplus.elephant.image.core.repository.dao.LogApiDao;
import com.xforceplus.elephant.image.core.repository.model.LogApiEntity;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LogApiRetryProcess extends AbstractProcess<RetryLogApiRequest, Boolean> {

    @Autowired
    private LogApiDao logApiDao;
    @Autowired
    private LogService logService;
    @Autowired
    private PaasTokenUtils paasTokenUtils;
    @Value("#{${logApi.retryUrl:}}")
    private Map<String, String> retryUrlMap;
    @Resource
    private HttpServletRequest servletRequest;

    @Override
    protected CommonResponse<Boolean> process(RetryLogApiRequest request) throws RuntimeException {
        try {
            final LogApiEntity logApiEntity = logApiDao.selectByPrimaryKey(request.getLogId());
            logApiEntity.setResult(null);
            logApiEntity.setExceptionDetail(null);
            if (SystemTypeEnum.IMAGE.getCode().equals(logApiEntity.getSystemType())) {
                logService.retryInterfaces(Arrays.asList(logApiEntity));
                return CommonResponse.ok("重试成功!");
            }
            final String retryUrl = retryUrlMap.get(String.valueOf(logApiEntity.getSystemType()));
            if (ValidatorUtil.isNotEmpty(retryUrl)) {
                final String url = retryUrl + "/common/retryLogApi";
                if (ValidatorUtil.isNotEmpty(request.getRequestParams())) {
                    logApiEntity.setParams(request.getRequestParams());
                }
                final String body = JSON.toJSONString(logApiEntity);
                // 获取token
                final String token = paasTokenUtils.getLoginToken();
                //拼接请求头部参数
                final Map<String, String> headers = new HashMap<>();
                headers.put("Content-Type", "application/json");
                headers.put("Cookie", servletRequest.getHeader("Cookie"));
                final String responseStr = HttpUtils.doJsonPost(url, headers, body);
                return JSON.parseObject(responseStr, CommonResponse.class);
            }
        } catch (Exception e) {
            logger.error("重试失败", e);
        }
        return CommonResponse.failed("重试失败!");
    }

}
