package com.xforceplus.elephant.image.controller.logistics;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.process.response.ListResult;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.LogisticsApi;
import com.xforceplus.elephant.image.client.model.GetLogisticsListRequest;
import com.xforceplus.elephant.image.client.model.LogisticsDTO;
import com.xforceplus.elephant.image.client.model.SaveLogisticsRequest;
import com.xforceplus.elephant.image.client.model.UpdateLogisticsRequest;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.logistics.process.DeleteLogisticsProcess;
import com.xforceplus.elephant.image.controller.logistics.process.GetLogisticsDetailProcess;
import com.xforceplus.elephant.image.controller.logistics.process.GetLogisticsListProcess;
import com.xforceplus.elephant.image.controller.logistics.process.SaveLogisticsProcess;
import com.xforceplus.elephant.image.controller.logistics.process.UpdateLogisticsProcess;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 版权：    上海云砺信息科技有限公司 创建者: 创建时间: 功能描述: 修改历史:
 */
@ApiV1Image
public class LogisticsController extends BaseController implements LogisticsApi {

    @Autowired
    private DeleteLogisticsProcess deleteLogisticsProcess;
    @Autowired
    private GetLogisticsDetailProcess getLogisticsDetailProcess;
    @Autowired
    private GetLogisticsListProcess getLogisticsListProcess;
    @Autowired
    private SaveLogisticsProcess saveLogisticsProcess;
    @Autowired
    private UpdateLogisticsProcess updateLogisticsProcess;

    @Override
    public CommonResponse<Boolean> deleteLogistics(@PathVariable("logisticsId") Long logisticsId, @RequestBody BaseRequest request) {
        return deleteLogisticsProcess.execute(logisticsId, request);
    }

    @Override
    public CommonResponse<LogisticsDTO> getLogisticsDetail(@PathVariable("logisticsId") Long logisticsId, BaseRequest request) {
        return getLogisticsDetailProcess.execute(logisticsId, request);
    }

    @Override
    public CommonResponse<ListResult<LogisticsDTO>> getLogisticsList(GetLogisticsListRequest request) {
        return getLogisticsListProcess.execute(request);
    }

    @Override
    public CommonResponse<List<Long>> saveLogistics(@RequestBody SaveLogisticsRequest request) {
        return saveLogisticsProcess.execute(request);
    }

    @Override
    public CommonResponse<Boolean> updateLogistics(@RequestBody UpdateLogisticsRequest request) {
        return updateLogisticsProcess.execute(request);
    }

}