package com.xforceplus.elephant.image.controller.logmq;

import com.xforceplus.elephant.basecommon.annotation.RedisLockMD5;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.process.response.ListResult;
import com.xforceplus.elephant.basecommon.rabbitmq.entity.MqMessageEntity;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.LogMqApi;
import com.xforceplus.elephant.image.client.model.GetLogMqListRequest;
import com.xforceplus.elephant.image.client.model.HandleMessageRequest;
import com.xforceplus.elephant.image.client.model.LogMqDTO;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.logmq.process.DeleteMessageProcess;
import com.xforceplus.elephant.image.controller.logmq.process.GetDeadLetterMessageListProcess;
import com.xforceplus.elephant.image.controller.logmq.process.GetLogMqDetailProcess;
import com.xforceplus.elephant.image.controller.logmq.process.GetLogMqListProcess;
import com.xforceplus.elephant.image.controller.logmq.process.HandleMessageProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 版权：    上海云砺信息科技有限公司 创建者: 创建时间: 功能描述: 修改历史:
 */
@ApiV1Image
public class LogMqController extends BaseController implements LogMqApi {

    @Autowired
    private GetLogMqListProcess getLogMqListProcess;
    @Autowired
    private GetLogMqDetailProcess getLogMqDetailProcess;
    @Autowired
    private GetDeadLetterMessageListProcess getDeadLetterMessageListProcess;
    @Autowired
    private HandleMessageProcess handleMessageProcess;
    @Autowired
    private DeleteMessageProcess deleteMessageProcess;

    @Override
    public CommonResponse<ListResult<LogMqDTO>> getLogMqList(GetLogMqListRequest request) {
        return getLogMqListProcess.execute(request);
    }

    @Override
    public CommonResponse<LogMqDTO> getLogMqDetail(@PathVariable("mqId") Long mqId, BaseRequest request) {
        return getLogMqDetailProcess.execute(mqId, request);
    }

    @Override
    public CommonResponse<ListResult<MqMessageEntity>> getDeadLetterMessageList(BaseRequest request) {
        return getDeadLetterMessageListProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse handleMessage(@RequestBody HandleMessageRequest request) {
        return handleMessageProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse deleteMessage(@RequestBody HandleMessageRequest request) {
        return deleteMessageProcess.execute(request);
    }

}