package com.xforceplus.elephant.image.controller.logmq.process;

import com.xforceplus.elephant.basecommon.baseconst.Constants;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.process.response.ListResult;
import com.xforceplus.elephant.basecommon.rabbitmq.entity.MqMessageEntity;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetDeadLetterMessageListProcess extends AbstractProcess<BaseRequest, ListResult<MqMessageEntity>> {

    @Autowired
    private MQUtils rabbitmqUtils;

    @Override
    protected CommonResponse<ListResult<MqMessageEntity>> process(BaseRequest request) throws RuntimeException {
        final List<MqMessageEntity> messageList = rabbitmqUtils.getMessageList(Constants.DEAD_LETTER_NUM, MQEnum.IMAGE_DEAD_LETTER_QUEUE);
        final int count = messageList.size();
        final ListResult<MqMessageEntity> result = new ListResult((long) count, messageList);
        return CommonResponse.ok("成功", result);
    }

}