package com.xforceplus.elephant.image.controller.logmq.process;

import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.process.response.ListResult;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.GetLogMqListRequest;
import com.xforceplus.elephant.image.client.model.LogMqDTO;
import com.xforceplus.elephant.image.core.repository.dao.LogMqDao;
import com.xforceplus.elephant.image.core.repository.model.LogMqExample;
import java.util.Date;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetLogMqListProcess extends AbstractProcess<GetLogMqListRequest, ListResult<LogMqDTO>> {

    @Autowired
    private LogMqDao logMqDao;

    @Override
    protected CommonResponse<ListResult<LogMqDTO>> process(GetLogMqListRequest request) throws RuntimeException {
        final LogMqExample logMqExample = new LogMqExample();
        final LogMqExample.Criteria criteria = logMqExample.createCriteria();
        logMqExample.setLimit(request.getRows());
        logMqExample.setOffset(request.getOffset());
        if (ValidatorUtil.isNotEmpty(request.getBillCode())) {
            criteria.andBillCodeEqualTo(request.getBillCode());
        }
        if (ValidatorUtil.isNotEmpty(request.getTicketCode())) {
            criteria.andTicketCodeEqualTo(request.getTicketCode());
        }
        if (ValidatorUtil.isNotEmpty(request.getListener())) {
            criteria.andListenerEqualTo(request.getListener());
        }
        if (ValidatorUtil.isNotEmpty(request.getSender())) {
            criteria.andSenderEqualTo(request.getTicketCode());
        }
        if (ValidatorUtil.isNotEmpty(request.getStatus())) {
            criteria.andStatusEqualTo(request.getStatus());
        }
        if (ValidatorUtil.isNotEmpty(request.getQueueName())) {
            criteria.andQueueNameEqualTo(request.getQueueName());
        }
        if (ValidatorUtil.isNotEmpty(request.getFinishTime()) && request.getFinishTime().size() == 2) {
            criteria.andFinishTimeBetween(new Date(request.getFinishTime().get(0)),
                new Date(request.getFinishTime().get(1)));
        }
        logMqExample.setOrderByClause("receive_time desc");
        final ListResult<LogMqDTO> result = new ListResult(
            logMqDao.countByExample(logMqExample),
            logMqDao.selectByExample(logMqExample).stream().map(entity -> {
                final LogMqDTO dto = new LogMqDTO();
                BeanUtils.copyProperties(entity, dto);
                return dto;
            }).collect(Collectors.toList()));
        return CommonResponse.ok("成功", result);
    }

}