package com.xforceplus.elephant.image.controller.logmq.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.HandleMessageRequest;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import java.util.Map;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HandleMessageProcess extends AbstractProcess<HandleMessageRequest, Boolean> {

    @Autowired
    private MQUtils rabbitmqUtils;

    @Override
    protected void check(HandleMessageRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getIndexId())) {
            throw new ValidationException("消息下标【indexId】不能为空");
        }
        if (ValidatorUtil.isEmpty(request.getExchange())) {
            throw new ValidationException("交换机【exchange】不能为空");
        }
        if (ValidatorUtil.isEmpty(request.getQueueName())) {
            throw new ValidationException("队列名【queueName】不能为空");
        }
        if (ValidatorUtil.isEmpty(request.getMessage())) {
            throw new ValidationException("消息体【message】不能为空");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(HandleMessageRequest request) throws RuntimeException {
        Map<String, Object> properties = null;
        if (!ValidatorUtil.isEmpty(request.getProperties())) {
            properties = JSONObject.parseObject(request.getProperties());
        }
        final Object objMess = JSONObject.parse(request.getMessage());
        rabbitmqUtils.handleMessage(request.getIndexId(), MQEnum.IMAGE_DEAD_LETTER_QUEUE, request.getExchange(), request.getQueueName(), objMess, properties, true);
        return CommonResponse.ok("处理成功");
    }

}