package com.xforceplus.elephant.image.controller.multipurpose;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.MultipurposeApi;
import com.xforceplus.elephant.image.client.model.ShareImageRequest;
import com.xforceplus.elephant.image.client.model.UsedAmountRequest;
import com.xforceplus.elephant.image.client.model.UsedAmountResponse;
import javax.validation.Valid;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author zhuxingsheng@gmail.com
 * @description: 一票多用
 * @date 2024/11/4 11:20
 */
@RequiredArgsConstructor
@ApiV1Image
public class MultipurposeController implements MultipurposeApi {

    private final MultipurposeProcess multipurposeProcess;

    @Override
    public CommonResponse<String> shareImage(@Valid @RequestBody ShareImageRequest request) {
        return multipurposeProcess.shareImage(request);
    }

    @Override
    public CommonResponse<UsedAmountResponse> editUsedAmount(@Valid @RequestBody UsedAmountRequest request) {
        return multipurposeProcess.editUsedAmount(request);
    }

}
