package com.xforceplus.elephant.image.controller.noauth;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.help.RedisUtils;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.BillDetailBean;
import com.xforceplus.elephant.image.client.model.GetBaseBillDetailRequest;
import com.xforceplus.elephant.image.client.model.GetImageListRequest;
import com.xforceplus.elephant.image.client.model.GetImageReturnLogListRequest;
import com.xforceplus.elephant.image.client.model.GetImageStreamRequest;
import com.xforceplus.elephant.image.client.model.GetTicketDataRequest;
import com.xforceplus.elephant.image.client.model.GetTicketDetailRequest;
import com.xforceplus.elephant.image.client.model.GetTicketTypeListRequest;
import com.xforceplus.elephant.image.client.model.ImageReturnDTO;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.image.process.GetImageStreamProcess;
import com.xforceplus.elephant.image.controller.noauth.process.NoAuthGetBillCodeProcess;
import com.xforceplus.elephant.image.controller.noauth.process.NoAuthGetBillDataImageDetailProcess;
import com.xforceplus.elephant.image.controller.noauth.process.NoAuthGetImageCountProcess;
import com.xforceplus.elephant.image.controller.noauth.process.NoAuthGetImageListProcess;
import com.xforceplus.elephant.image.controller.noauth.process.NoAuthGetImageReturnLogListProcess;
import com.xforceplus.elephant.image.controller.noauth.process.NoAuthGetInvoiceTypeListProcess;
import com.xforceplus.elephant.image.controller.noauth.process.NoAuthGetTicketDataProcess;
import com.xforceplus.elephant.image.controller.noauth.process.NoAuthGetTicketDetailProcess;
import com.xforceplus.elephant.image.core.business.infrastructure.feign.UltramanPfcpClient;
import com.xforceplus.elephant.image.core.domain.image.bean.ImageSearchResultBean;
import com.xforceplus.elephant.image.core.util.ImageUtils;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.AuthorizedUser;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.metadata.domain.vo.dto.Response;
import com.xforceplus.ultraman.metadata.domain.vo.dto.RowItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.UltPageBoItem;
import com.xforceplus.ultraman.sdk.controller.DictController;
import com.xforceplus.ultraman.sdk.controller.EntityController;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.naming.directory.NoSuchAttributeException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/view/bill")
public class BillViewController extends BaseController {

    @Autowired
    private ContextService contextService;
    @Autowired
    private NoAuthGetBillCodeProcess getBillCodeProcess;
    @Autowired
    private NoAuthGetBillDataImageDetailProcess getBillDataImageDetailProcess;
    @Autowired
    private NoAuthGetImageListProcess getImageListProcess;
    @Autowired
    private NoAuthGetImageCountProcess getImageCountProcess;
    @Autowired
    private GetImageStreamProcess getImageStreamProcess;
    @Autowired
    private NoAuthGetImageReturnLogListProcess getImageReturnLogListProcess;
    @Autowired
    private NoAuthGetTicketDetailProcess getTicketDetailProcess;
    @Autowired
    private NoAuthGetTicketDataProcess getTicketDataProcess;
    @Autowired
    private DictController dictController;
    @Autowired
    private EntityController entityController;
    @Autowired
    private RedisUtils redisUtils;
    @Resource
    private HttpServletRequest servletRequest;
    @Autowired
    private NoAuthGetInvoiceTypeListProcess noAuthGetInvoiceTypeListProcess;
    @Autowired
    private UltramanPfcpClient ultramanPfcpClient;

    private JSONObject check() {
        final String keyCode = servletRequest.getParameter("keyCode");
        if (ValidatorUtil.isEmpty(keyCode)) {
            throw new ValidationException("请携带调阅凭证");
        }
        final String result = (String) redisUtils.get(keyCode);
        logger.debug("获取到凭证【{}】对应的请求【{}】", keyCode, result);
        if (ValidatorUtil.isEmpty(result)) {
            throw new ValidationException("调阅凭证已过期，请重新申请");
        }
        final JSONObject obj;
        try {
            obj = JSON.parseObject(result);
        } catch (final Exception e) {
            throw new ValidationException("调阅凭证异常");
        }
        if (ValidatorUtil.isEmpty(obj)) {
            throw new ValidationException("无效的调阅凭证，请重新申请");
        }
        final AuthorizedUser user = new AuthorizedUser();
        user.setTenantId(obj.getLong("tenantId"));
        user.setTenantCode(obj.getString("tenantCode"));
        user.setId(0L);
        user.setUserCode(obj.getString("userCode"));
        user.setUserName(obj.getString("userName"));
        UserInfoHolder.put(user);
        contextService.set(ContextKeys.StringKeys.TENANTID_KEY, obj.getString("tenantId"));
        contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, obj.getString("tenantCode"));
        contextService.set(ContextKeys.LongKeys.ID, 0L);
        contextService.set(ContextKeys.StringKeys.USER_DISPLAYNAME, obj.getString("userName"));
        return obj;
    }

    @AuthorizedDefinition(authorization = false)
    @RequestMapping(value = "/baseBill/getBillCode/{key}",
        produces = {"application/json"},
        method = RequestMethod.GET)
    public CommonResponse getBillCode(@PathVariable final String key, @Valid final BaseRequest request) {
        try {
            check();
            return getBillCodeProcess.execute(key, request);
        } finally {
            UserInfoHolder.clearContext();
            contextService.clear();
        }
    }

    @AuthorizedDefinition(authorization = false)
    @RequestMapping(value = "/baseBill/getBaseBillDetail",
        produces = {"application/json"},
        method = RequestMethod.GET)
    public CommonResponse<BillDetailBean> getBaseBillDetail(final GetBaseBillDetailRequest request) {
        try {
            final JSONObject billInfo = check();
            if (ValidatorUtil.isNotEmpty(request.getBillCode())) {
                request.setBillCode(billInfo.getString("requestNo"));
            }
            return getBillDataImageDetailProcess.execute(request);
        } finally {
            UserInfoHolder.clearContext();
            contextService.clear();
        }
    }

    @AuthorizedDefinition(authorization = false)
    @RequestMapping(value = "/image",
        produces = {"application/json"},
        method = RequestMethod.GET)
    public CommonResponse<ImageSearchResultBean> getImageList(final GetImageListRequest request) {
        try {
            final JSONObject billInfo = check();
            if (ValidatorUtil.isNotEmpty(request.getBillCode())) {
                request.setBillCode(billInfo.getString("requestNo"));
            }
            request.setRid(servletRequest.getParameter("keyCode"));
            request.setImageIds(ImageUtils.asList(billInfo.getJSONArray("imageIds")));
            return getImageListProcess.execute(request);
        } finally {
            UserInfoHolder.clearContext();
            contextService.clear();
        }
    }

    @AuthorizedDefinition(authorization = false)
    @RequestMapping(value = "/image/list",
        produces = {"application/json"},
        method = RequestMethod.POST)
    public CommonResponse<ImageSearchResultBean> getImageListPost(@RequestBody final GetImageListRequest request) {
        try {
            final JSONObject billInfo = check();
            if (ValidatorUtil.isNotEmpty(request.getBillCode())) {
                request.setBillCode(billInfo.getString("requestNo"));
            }
            billInfo.getJSONArray("imageIds");
            request.setRid(servletRequest.getParameter("keyCode"));
            request.setImageIds(ImageUtils.asList(billInfo.getJSONArray("imageIds")));
            return getImageListProcess.execute(request);
        } finally {
            UserInfoHolder.clearContext();
            contextService.clear();
        }
    }

    @AuthorizedDefinition(authorization = false)
    @RequestMapping(value = "/image/count",
        produces = {"application/json"},
        method = RequestMethod.GET)
    public CommonResponse<Map<String, Long>> getImageCount(final GetImageListRequest request) {
        try {
            final JSONObject billInfo = check();
            if (ValidatorUtil.isNotEmpty(request.getBillCode())) {
                request.setBillCode(billInfo.getString("requestNo"));
            }
            return getImageCountProcess.execute(request);
        } finally {
            UserInfoHolder.clearContext();
            contextService.clear();
        }
    }

    @AuthorizedDefinition(authorization = false)
    @CrossOrigin
    @RequestMapping(value = "/image/{imageId:[0-9]+}.{fileExt}",
        produces = {"application/octet-stream"},
        method = RequestMethod.GET)
    public Object getImageFile(@PathVariable("imageId") final Long imageId, @PathVariable("fileExt") final String fileExt, final GetImageStreamRequest request) {
        try {
            check();
            return getImageStreamProcess.execute(imageId, request);
        } finally {
            UserInfoHolder.clearContext();
            contextService.clear();
        }
    }

    @AuthorizedDefinition(authorization = false)
    @RequestMapping(value = "/imageReturn/getImageReturnList",
        produces = {"application/json"},
        method = RequestMethod.GET)
    public CommonResponse<List<ImageReturnDTO>> getImageReturnList(final GetImageReturnLogListRequest request) {
        try {
            final JSONObject billInfo = check();
            if (ValidatorUtil.isNotEmpty(request.getBillCode())) {
                request.setBillCode(billInfo.getString("requestNo"));
            }
            return getImageReturnLogListProcess.execute(request);
        } finally {
            UserInfoHolder.clearContext();
            contextService.clear();
        }
    }

    @AuthorizedDefinition(authorization = false)
    @RequestMapping(value = "/ticket/getTicketDetail",
        produces = {"application/json"},
        method = RequestMethod.GET)
    public CommonResponse<JSONObject> getTicketDetail(final GetTicketDetailRequest request) {
        try {
            check();
            request.setRid(servletRequest.getParameter("keyCode"));
            return getTicketDetailProcess.execute(request);
        } finally {
            UserInfoHolder.clearContext();
            contextService.clear();
        }
    }

    @AuthorizedDefinition(authorization = false)
    @RequestMapping(value = "/ticket/getTicketData",
        produces = {"application/json"},
        method = RequestMethod.GET)
    public CommonResponse<Map<String, Object>> getTicketData(final GetTicketDataRequest request) {
        try {
            check();
            return getTicketDataProcess.execute(request);
        } finally {
            UserInfoHolder.clearContext();
            contextService.clear();
        }
    }

    @AuthorizedDefinition(authorization = false)
    @GetMapping({"/enums/options"})
    @ResponseBody
    public ResponseEntity getDicts(@RequestParam(required = false, value = "ids") final String[] enumIds) {
        try {
            check();
            return dictController.getDicts(enumIds);
        } finally {
            UserInfoHolder.clearContext();
            contextService.clear();
        }
    }

    @AuthorizedDefinition(authorization = false)
    @GetMapping({"/form-settings/{id}"})
    @ResponseBody
    public Response<List<UltPageBoItem>> pageBoSetings(@PathVariable final Long id, @RequestParam(value = "tenantCode", required = false) final String tenantCode,
        @RequestParam(value = "pageCode", required = false) final String pageCode) {
        try {
            check();
            final String currentTenantCode = ValidatorUtil.isEmpty(tenantCode) ? UserInfoHolder.get().getTenantCode() : tenantCode;
            logger.debug("请求参数，id:{}, tenantCode:{}", id, currentTenantCode);
            return ultramanPfcpClient.pageBoSettings(id, currentTenantCode, pageCode);
        } finally {
            UserInfoHolder.clearContext();
            contextService.clear();
        }
    }

    @AuthorizedDefinition(authorization = false)
    @GetMapping(value = "/form-settings/codes/{code}", produces = {"application/json"})
    @ResponseBody
    public ResponseEntity pageBoSeetingsByCode(@PathVariable final String code, @RequestParam(value = "tenantCode", required = false) final String tenantCode) throws NoSuchAttributeException {
        try {
            check();
            final String currentTenantCode = ValidatorUtil.isEmpty(tenantCode) ? UserInfoHolder.get().getTenantCode() : tenantCode;
            logger.debug("请求参数，code:{}, tenantCode:{}", code, currentTenantCode);
            return ResponseEntity.ok(ultramanPfcpClient.formSettings(UserInfoHolder.get().getTenantId(), currentTenantCode, code));
        } finally {
            UserInfoHolder.clearContext();
            contextService.clear();
        }
    }

    @AuthorizedDefinition(authorization = false)
    @PostMapping({"/bos/{boId}/entities/query"})
    @ResponseBody
    public ResponseEntity<Response<RowItem<Map<String, Object>>>> conditionQuery(@ApiParam("元数据对象ID") @PathVariable String boId,
        @ApiParam("版本, 暂时无特别作用") @RequestParam(required = false, value = "v") String version, @ApiParam("页面编码") @RequestParam(required = false, value = "pageCode") String pageCode,
        @ApiParam("忽略count") @RequestParam(required = false, value = "simplePagination") boolean simplePagination,
        @ApiParam("查询条件, 其中field名称为 xx/xx时表示为子类字段, entity 中 fields指定返回当前对象返回字段, entities 指定关联对象返回字段, conditions 中 fields指定当前对象条件字段, entities 指定关联对象条件字段") @RequestBody ConditionQueryRequest condition,
        HttpServletRequest request) {
        try {
            check();
            return entityController.conditionQuery(boId, version, pageCode, simplePagination, condition, request);
        } finally {
            UserInfoHolder.clearContext();
            contextService.clear();
        }
    }

    @AuthorizedDefinition(authorization = false)
    @GetMapping({"/bos/{boId}/entities/{id}"})
    @ResponseBody
    public ResponseEntity<Response<Map<String, Object>>> singleQuery(@PathVariable final String boId, @PathVariable final String id, @RequestParam(required = false, value = "v") final String version,
        @RequestParam(required = false, value = "pageCode") final String pageCode) {
        try {
            check();
            return entityController.singleQuery(boId, id, version, pageCode);
        } finally {
            UserInfoHolder.clearContext();
            contextService.clear();
        }
    }

    @AuthorizedDefinition(authorization = false)
    @RequestMapping(value = "/ticket/getInvoiceTypeList",
        produces = {"application/json"},
        method = RequestMethod.GET)
    public CommonResponse getInvoiceTypeList(final GetTicketTypeListRequest request) {
        try {
            check();
            return noAuthGetInvoiceTypeListProcess.execute(request);
        } finally {
            UserInfoHolder.clearContext();
            contextService.clear();
        }
    }

}
