package com.xforceplus.elephant.image.controller.noauth.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.enums.common.PageCodeEnum;
import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.BaseBillDTO;
import com.xforceplus.elephant.image.client.model.BillDetailBean;
import com.xforceplus.elephant.image.client.model.GetBaseBillDetailRequest;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.elephant.image.core.util.EntityServiceExWrapper;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.metadata.domain.vo.dto.UltPageBoItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NoAuthGetBillDataImageDetailProcess extends AbstractProcess<GetBaseBillDetailRequest, BillDetailBean> {

    @Autowired
    private BaseBillService baseBillService;
    @Autowired
    private BillImageTicketService billImageTicketService;

    @Autowired
    private EntityServiceExWrapper entityServiceEx;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    protected CommonResponse<BillDetailBean> process(GetBaseBillDetailRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        //默认影像采集
        final String pageCode = ValidatorUtil.isNotEmpty(request.getPageCode()) ? request.getPageCode() : PageCodeEnum.SCAN.getCode();
        final BillDetailBean billDetailBean = new BillDetailBean();
        logger.info("详情页面 tenantId:{} ,billCode:{}", authorizedUser.getTenantId(), request.getBillCode());
        final BaseBill entity = baseBillService.selectBaseBillByCode(authorizedUser.getTenantId(), request.getBillCode());
        if (ValidatorUtil.isEmpty(entity)) {
            return CommonResponse.failed("未找到该业务单");
        }
        final BaseBillDTO dto = new JSONObject(entity.toOQSMap()).toJavaObject(BaseBillDTO.class);
        final Map<String, Long> map = billImageTicketService.getBillImageType(entity.getBillCode(), entity.getId(), authorizedUser.getTenantId(), authorizedUser.getTenantCode(), pageCode);
        final List<UltPageBoItem> boItemList = entityServiceEx.findPageBos(pageCode, authorizedUser.getTenantCode());
        final String billTypeName = boItemList.stream()
            .filter(ultPageBoItem -> ultPageBoItem.getBoCode().equals(entity.getBillTypeCode()))
            .map(ultPageBoItem -> ValidatorUtil.isNotEmpty(ultPageBoItem.getRemark()) ? ultPageBoItem.getRemark() : ultPageBoItem.getBoName())
            .findFirst().orElse(null);
        dto.setBillTypeName(billTypeName);
        billDetailBean.setImageTotalCount(map.get("totalCount"));
        map.remove("totalCount");
        billDetailBean.setBaseBillDTO(dto);
        billDetailBean.setCountMap(map);
        //查询单据信息，返回单据详情页表单map
        final Map<String, Object> billMap = getBillMap(authorizedUser.getTenantId(), entity);
        billMap.put("bill_type_name", billTypeName);
        billDetailBean.setBillMap(billMap);
        return CommonResponse.ok("", billDetailBean);
    }

    /**
     * 查询单据信息，返回单据详情页表单map
     *
     * @param tenantId 租户ID
     * @param entity   对象
     * @return 结果
     * @author rongying
     * @date 2021/4/30 11:06
     */
    public Map<String, Object> getBillMap(Long tenantId, BaseBill entity) {
        final Map<String, Object> billMap = new HashMap<>();
        if (ValidatorUtil.isEmpty(entity)) {
            return billMap;
        }
        if (ValidatorUtil.isEmpty(tenantId) || ValidatorUtil.isEmpty(entity.getBillCode()) || ValidatorUtil.isEmpty(entity.getBillTypeCode())) {
            return billMap;
        }
        final List<Map<String, Object>> billMapList = baseBillService.selectBillByBillCode(tenantId, entity.getBillCode(), entity.getBillTypeCode());
        if (ValidatorUtil.isEmpty(billMapList)) {
            return billMap;
        }
        return billMapList.get(0);
    }

}
