package com.xforceplus.elephant.image.controller.noauth.process;

import com.xforceplus.elephant.basecommon.enums.EntityConstant;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.GetTicketDataRequest;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.domain.ticket.TicketService;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import java.util.Map;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NoAuthGetTicketDataProcess extends AbstractProcess<GetTicketDataRequest, Map<String, Object>> {

    @Autowired
    private TicketService ticketService;
    @Autowired
    private ImageService imageService;

    @Override
    protected void check(GetTicketDataRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getTicketId())) {
            throw new ValidationException("单证ID【ticketId】不能为空");
        }
    }

    @Override
    protected CommonResponse<Map<String, Object>> process(GetTicketDataRequest request) throws RuntimeException {
        final Ticket ticket = ticketService.selectBaseTicketById(request.getTicketId());
        if (null == ticket) {
            return CommonResponse.failed("没有查询到单证数据.");
        }
        final Map<String, Object> map = ticketService.selectByParentTicketID(EntityConstant.TICKET, ticket.getTicketCode(), request.getTicketId());
        if (null == map) {
            return CommonResponse.failed("没有查询到单证数据.");
        }
        //电票源文件名称
        final Image image = imageService.selectOne(ticket.getTenantId(), ticket.getImageId());
        if (image != null) {
            map.put("file_name", image.getFileName());
        }
        return CommonResponse.ok("成功", map);
    }

}