package com.xforceplus.elephant.image.controller.pubsublog;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.PubSubLogApi;
import com.xforceplus.elephant.image.client.model.GetPubSubLogListRequest;
import com.xforceplus.elephant.image.client.model.RetryPubSubRequest;
import com.xforceplus.elephant.image.controller.pubsublog.process.GetPubSubLogDetailProcess;
import com.xforceplus.elephant.image.controller.pubsublog.process.GetPubSubLogListProcess;
import com.xforceplus.elephant.image.controller.pubsublog.process.PubSubRetryProcess;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 版权：    上海云砺信息科技有限公司 创建者: 创建时间: 功能描述: 修改历史:
 */
@ApiV1Image
public class PubSubLogController implements PubSubLogApi {

    @Autowired
    private GetPubSubLogListProcess getPubSubLogListProcess;
    @Autowired
    private GetPubSubLogDetailProcess getPubSubLogDetailProcess;
    @Autowired
    private PubSubRetryProcess pubSubRetryProcess;

    @Override
    public CommonResponse getPubSubLogList(@Valid GetPubSubLogListRequest request) {
        return getPubSubLogListProcess.execute(request);
    }

    @Override
    public CommonResponse getLogApiDetail(Long logId, @Valid BaseRequest request) {
        return getPubSubLogDetailProcess.execute(logId, request);
    }

    @Override
    public CommonResponse pubSubRetry(@RequestBody RetryPubSubRequest request) {
        return pubSubRetryProcess.execute(request);
    }

}
