package com.xforceplus.elephant.image.controller.pubsublog.process;

import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.process.AbstractKeyProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.PubSubLogDTO;
import com.xforceplus.elephant.image.core.repository.dao.PubSubLogDao;
import com.xforceplus.elephant.image.core.repository.model.PubSubLogEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetPubSubLogDetailProcess extends AbstractKeyProcess<Long, BaseRequest, PubSubLogDTO> {

    @Autowired
    private PubSubLogDao pubSubLogDao;

    @Override
    protected CommonResponse<PubSubLogDTO> process(Long logId, BaseRequest request) throws RuntimeException {
        final PubSubLogEntity entity = pubSubLogDao.selectByPrimaryKey(logId);
        final PubSubLogDTO dto = new PubSubLogDTO();
        BeanUtils.copyProperties(entity, dto);

        return CommonResponse.ok("成功", dto);
    }

}