package com.xforceplus.elephant.image.controller.pubsublog.process;

import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.process.response.ListResult;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.GetPubSubLogListRequest;
import com.xforceplus.elephant.image.client.model.PubSubLogDTO;
import com.xforceplus.elephant.image.core.repository.dao.PubSubLogDao;
import com.xforceplus.elephant.image.core.repository.model.PubSubLogExample;
import java.util.Date;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetPubSubLogListProcess extends AbstractProcess<GetPubSubLogListRequest, ListResult<PubSubLogDTO>> {

    @Autowired
    private PubSubLogDao pubSubLogDao;

    @Override
    protected CommonResponse<ListResult<PubSubLogDTO>> process(GetPubSubLogListRequest request) throws RuntimeException {
        final PubSubLogExample pubSubLogExample = new PubSubLogExample();
        final PubSubLogExample.Criteria criteria = pubSubLogExample.createCriteria();
        if (ValidatorUtil.isNotEmpty(request.getNumber())) {
            criteria.andNumberEqualTo(request.getNumber());
        }
        if (ValidatorUtil.isNotEmpty(request.getRequestName())) {
            criteria.andRequestNameEqualTo(request.getRequestName());
        }
        if (ValidatorUtil.isNotEmpty(request.getReciver())) {
            criteria.andReciverEqualTo(request.getReciver());
        }
        if (ValidatorUtil.isNotEmpty(request.getSender())) {
            criteria.andSenderEqualTo(request.getSender());
        }
        if (ValidatorUtil.isNotEmpty(request.getType())) {
            criteria.andTypeEqualTo(request.getType());
        }
        if (ValidatorUtil.isNotEmpty(request.getCreateTime()) && request.getCreateTime().size() == 2) {
            criteria.andCreateTimeBetween(new Date(request.getCreateTime().get(0)),
                new Date(request.getCreateTime().get(1)));
        }
        if (ValidatorUtil.isNotEmpty(request.getIsSuccessful())) {
            criteria.andIsSuccessfulEqualTo(request.getIsSuccessful());
        }
        pubSubLogExample.setLimit(request.getRows());
        pubSubLogExample.setOffset(request.getOffset());
        pubSubLogExample.setOrderByClause("create_time desc");

        final ListResult<PubSubLogDTO> result = new ListResult(
            pubSubLogDao.countByExample(pubSubLogExample),
            pubSubLogDao.selectByExample(pubSubLogExample).stream().map(entity -> {
                final PubSubLogDTO dto = new PubSubLogDTO();
                BeanUtils.copyProperties(entity, dto);
                return dto;
            }).collect(Collectors.toList()));
        return CommonResponse.ok("成功", result);
    }

}
