package com.xforceplus.elephant.image.controller.pubsublog.process;

import static com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.RetryPubSubRequest;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.repository.dao.PubSubLogDao;
import com.xforceplus.elephant.image.core.repository.model.PubSubLogEntity;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author yuhongxia
 * @description pubsub重试
 * @date 2021/4/19 14:28
 */
@Service
public class PubSubRetryProcess extends AbstractProcess<RetryPubSubRequest, Boolean> {

    @Autowired
    private PubSubLogDao pubSubLogDao;
    @Autowired
    private MQUtils rabbitmqUtils;

    @Override
    protected CommonResponse<Boolean> process(RetryPubSubRequest request) throws RuntimeException {
        final PubSubLogEntity pubSubLogEntity = pubSubLogDao.selectByPrimaryKey(request.getLogId());
        if (ValidatorUtil.isEmpty(pubSubLogEntity)) {
            return CommonResponse.failed("重试失败,未查询到该条记录");
        }
        final Map<String, Object> headers = new HashMap<>();
        headers.put(TENANT_CODE, UserInfoHolder.get().getTenantCode());
        rabbitmqUtils.sendByDirectExchange(MQEnum.IMAGE_PUB_SUB_RETRY_QUEUE, pubSubLogEntity, headers);
        return CommonResponse.ok("重试成功");
    }

}
