package com.xforceplus.elephant.image.controller.receivefiles;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.ReceiveFilesApi;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.receivefiles.process.DownloadReceiveFilesProcess;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;

@ApiV1Image
public class ReceiveFilesController extends BaseController implements ReceiveFilesApi {

    @Autowired
    private DownloadReceiveFilesProcess downloadReceiveFilesProcess;

    @AuthorizedDefinition(authorization = false)
    @CrossOrigin
    @Override
    public Object download(@PathVariable("id") Long id, @PathVariable("fileExt") String fileExt, BaseRequest request) {
        return downloadReceiveFilesProcess.execute(id, request);
    }

}
