package com.xforceplus.elephant.image.controller.receivefiles.process;

import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.vaildate.Validator;
import com.xforceplus.elephant.image.core.business.infrastructure.port.FileService;
import com.xforceplus.elephant.image.core.domain.receivefiles.ReceiveFilesService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.ReceiveFiles;
import java.io.InputStream;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StreamUtils;

@Service
public class DownloadReceiveFilesProcess implements Validator {

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ReceiveFilesService receiveFilesService;

    @Autowired
    private FileService fileService;

    protected void check(Long id, BaseRequest request) throws ValidationException {
        if (id == null) {
            throw new ValidationException("主键不能为空");
        }
    }

    public ResponseEntity<byte[]> execute(Long id, BaseRequest request) {
        check(id, request);
        return process(id, request);
    }

    protected ResponseEntity<byte[]> process(Long id, BaseRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final ReceiveFiles entity = receiveFilesService.selectBillByReceiveFiles(id);
        checkEmpty(entity, "文件不存在");
        if (entity.getImageFileUrl().startsWith("http")) {
            try (InputStream is = HttpUtils.doGetInputStream(entity.getImageFileUrl())) {
                final byte[] bytes = StreamUtils.copyToByteArray(is);
                return ResponseEntity.ok()
                    .header("Content-Disposition", "attachment;fileName=" + entity.getId() + entity.getFileSuffix())
                    .contentType(fileService.mediaType(entity.getFileSuffix()))
                    .contentLength(bytes.length).body(bytes);
            } catch (Exception e) {
                logger.error("下载失败", e);
            }
        } else {
            try (InputStream is = fileService.getFileInputStream(user.getTenantId(), user.getId(), entity.getImageFileUrl())) {
                final byte[] bytes = StreamUtils.copyToByteArray(is);
                return ResponseEntity.ok()
                    .header("Content-Disposition", "attachment;fileName=" + entity.getId() + entity.getFileSuffix())
                    .contentType(fileService.mediaType(entity.getFileSuffix()))
                    .contentLength(bytes.length).body(bytes);
            } catch (Exception e) {
                logger.error("下载失败", e);
            }
        }
        return ResponseEntity.notFound().build();
    }

}
