package com.xforceplus.elephant.image.controller.specialinvoice.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.core.business.enums.DictEnum;
import com.xforceplus.elephant.image.core.domain.config.ConfigDictionaryService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.List;
import java.util.Map;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * 特殊行业发票配置
 * @author rongying
 * @date 2023/6/26 11:06
 */
@Service
@RequiredArgsConstructor
public class GetSpecialInvoiceConfigProcess extends AbstractProcess<BaseRequest, Object> {

    private final ConfigDictionaryService configDictionaryService;

    @Override
    protected CommonResponse<Object> process(final BaseRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        if (null == user) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        // 数据源
        final String config = configDictionaryService.select(user.getTenantId(), DictEnum.SPECIAL_INVOICE_CONFIG.getCode());
        if (ValidatorUtil.isEmpty(config)) {
            return CommonResponse.failed("未获取到特殊行业发票配置");
        }
        final List<Map> configList = JSONObject.parseArray(config, Map.class);
        return CommonResponse.ok("成功", configList);
    }
    
}
