package com.xforceplus.elephant.image.controller.ticket;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.RedisLockMD5;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.process.response.ListResult;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.TicketApi;
import com.xforceplus.elephant.image.client.model.BackNonInvoiceRequest;
import com.xforceplus.elephant.image.client.model.BatchTicketRequest;
import com.xforceplus.elephant.image.client.model.ClearTicketDataRequest;
import com.xforceplus.elephant.image.client.model.DeleteTicketListRequest;
import com.xforceplus.elephant.image.client.model.GetBaseTicketListRequest;
import com.xforceplus.elephant.image.client.model.GetClaimTicketListRequest;
import com.xforceplus.elephant.image.client.model.GetExceAndWarnInfoRequest;
import com.xforceplus.elephant.image.client.model.GetHistoryLabelsRequest;
import com.xforceplus.elephant.image.client.model.GetTicketDataRequest;
import com.xforceplus.elephant.image.client.model.GetTicketDetailRequest;
import com.xforceplus.elephant.image.client.model.GetTicketManyRequest;
import com.xforceplus.elephant.image.client.model.GetTicketTypeListRequest;
import com.xforceplus.elephant.image.client.model.GetVerifyTagRequest;
import com.xforceplus.elephant.image.client.model.ReCheckTicketRequest;
import com.xforceplus.elephant.image.client.model.ReSendTicketRequest;
import com.xforceplus.elephant.image.client.model.ReSendTicketsRequest;
import com.xforceplus.elephant.image.client.model.SaveTicketDataRequest;
import com.xforceplus.elephant.image.client.model.SaveTicketDetailLabelsRequest;
import com.xforceplus.elephant.image.client.model.SaveTicketLabelsRequest;
import com.xforceplus.elephant.image.client.model.SelectTicketAttachmentRequest;
import com.xforceplus.elephant.image.client.model.SendVerifyRequest;
import com.xforceplus.elephant.image.client.model.SubmitCancelRequest;
import com.xforceplus.elephant.image.client.model.SubmitTicketRequest;
import com.xforceplus.elephant.image.client.model.UploadByQrcodeRequest;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.ticket.process.BackNonInvoiceProcess;
import com.xforceplus.elephant.image.controller.ticket.process.ClearTicketDataProcess;
import com.xforceplus.elephant.image.controller.ticket.process.DeletePublicTicketListProcess;
import com.xforceplus.elephant.image.controller.ticket.process.DetailSaveLabelsProcess;
import com.xforceplus.elephant.image.controller.ticket.process.GetBaseTicketListProcess;
import com.xforceplus.elephant.image.controller.ticket.process.GetClaimTicketListProcess;
import com.xforceplus.elephant.image.controller.ticket.process.GetExceAndWarnInfoProcess;
import com.xforceplus.elephant.image.controller.ticket.process.GetHistoryLabelsProcess;
import com.xforceplus.elephant.image.controller.ticket.process.GetInvoiceTypeListProcess;
import com.xforceplus.elephant.image.controller.ticket.process.GetRepeatTicketProcess;
import com.xforceplus.elephant.image.controller.ticket.process.GetTicketDataProcess;
import com.xforceplus.elephant.image.controller.ticket.process.GetTicketDetailProcess;
import com.xforceplus.elephant.image.controller.ticket.process.GetTicketManyProcess;
import com.xforceplus.elephant.image.controller.ticket.process.GetTicketTypeListProcess;
import com.xforceplus.elephant.image.controller.ticket.process.GetVerifyTagProcess;
import com.xforceplus.elephant.image.controller.ticket.process.InsertBillByQrcodeProcess;
import com.xforceplus.elephant.image.controller.ticket.process.OperationDeleteTicketProcess;
import com.xforceplus.elephant.image.controller.ticket.process.PDFVerifyPassProcess;
import com.xforceplus.elephant.image.controller.ticket.process.ReCheckTicketProcess;
import com.xforceplus.elephant.image.controller.ticket.process.ReSendTicketProcess;
import com.xforceplus.elephant.image.controller.ticket.process.SelectTicketAttachmentProcess;
import com.xforceplus.elephant.image.controller.ticket.process.SendPDFVerifyProcess;
import com.xforceplus.elephant.image.controller.ticket.process.SendVerifyFacadeProcess;
import com.xforceplus.elephant.image.controller.ticket.process.SubmitCancelProcess;
import com.xforceplus.elephant.image.controller.ticket.process.TicketSaveLabelsProcess;
import com.xforceplus.elephant.image.controller.ticket.process.UploadByQrcodeProcess;
import com.xforceplus.elephant.image.controller.ticket.process.deleteperson.DefaultDeletePersonTicketListProcess;
import com.xforceplus.elephant.image.controller.ticket.process.save.DefaultSaveTicketDataProcess;
import com.xforceplus.elephant.image.controller.ticket.process.submit.DefaultSubmitTicketProcess;
import com.xforceplus.elephant.image.controller.ticket.process.submit.SubmitCheckProcess;
import com.xforceplus.elephant.image.core.business.application.collect.ticket.domain.TicketTypeConfig;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 版权：    上海云砺信息科技有限公司 创建者: 创建时间: 功能描述: 修改历史:
 */
@ApiV1Image
public class TicketController extends BaseController implements TicketApi {

    @Autowired
    private DeletePublicTicketListProcess deletePublicTicketListProcess;
    @Autowired
    private GetTicketDetailProcess getTicketDetailProcess;
    @Autowired
    private GetTicketTypeListProcess getTicketTypeListProcess;
    @Autowired
    private GetTicketDataProcess getTicketDataProcess;
    @Autowired
    private ClearTicketDataProcess clearTicketDataProcess;
    @Autowired
    private GetExceAndWarnInfoProcess getExceAndWarnInfoProcess;
    @Autowired
    private GetClaimTicketListProcess getClaimTicketListProcess;
    @Autowired
    private GetTicketManyProcess getTicketManyProcess;
    @Autowired
    private SelectTicketAttachmentProcess selectTicketAttachmentProcess;
    @Autowired
    private ReSendTicketProcess reSendTicketProcess;
    @Autowired
    private ReCheckTicketProcess reCheckTicketProcess;
    @Autowired
    private SendVerifyFacadeProcess sendVerifyFacadeProcess;
    @Autowired
    private GetInvoiceTypeListProcess getInvoiceTypeListProcess;
    @Autowired
    private GetBaseTicketListProcess getBaseTicketListProcess;
    @Autowired
    private SendPDFVerifyProcess sendPDFVerifyProcess;
    @Autowired
    private PDFVerifyPassProcess pdfVerifyPassProcess;
    @Autowired
    private GetRepeatTicketProcess getRepeatTicketProcess;
    @Autowired
    private OperationDeleteTicketProcess operationDeleteTicketProcess;
    @Autowired
    private GetVerifyTagProcess getVerifyTagProcess;
    @Autowired
    private SubmitCancelProcess submitCancelProcess;
    @Autowired
    private SubmitCheckProcess submitCheckProcess;
    @Autowired
    private UploadByQrcodeProcess uploadByQrcodeProcess;
    @Autowired
    private BackNonInvoiceProcess backNonInvoiceProcess;
    @Autowired
    private InsertBillByQrcodeProcess insertBillByQrcodeProcess;

    @RedisLockMD5()
    @Override
    public CommonResponse deletePersonTicketList(@RequestBody DeleteTicketListRequest request) {
        return process(DefaultDeletePersonTicketListProcess.class).execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse deletePublicTicketList(@RequestBody DeleteTicketListRequest request) {
        return deletePublicTicketListProcess.execute(request);
    }

    @Override
    public CommonResponse<JSONObject> getTicketDetail(GetTicketDetailRequest request) {
        return getTicketDetailProcess.execute(request);
    }

    @Override
    public CommonResponse getTicketMany(@RequestBody GetTicketManyRequest request) {
        return getTicketManyProcess.execute(request);
    }

    @Override
    public CommonResponse<List<TicketTypeConfig>> getTicketTypeList(GetTicketTypeListRequest request) {
        return getTicketTypeListProcess.execute(request);
    }

    @Override
    public CommonResponse<Map<String, Object>> getTicketData(GetTicketDataRequest request) {
        return getTicketDataProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse clearTicketData(@RequestBody ClearTicketDataRequest request) {
        return clearTicketDataProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse sendVerify(@RequestBody SendVerifyRequest request) {
        return sendVerifyFacadeProcess.execute(request);
    }

    @Override
    public CommonResponse<List<String>> getExceAndWarnInfo(GetExceAndWarnInfoRequest request) {
        return getExceAndWarnInfoProcess.execute(request);
    }

    @Override
    public CommonResponse<ListResult<JSONObject>> getClaimTicketList(GetClaimTicketListRequest request) {
        return getClaimTicketListProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse saveTicketData(@RequestBody SaveTicketDataRequest request) {
        return process(DefaultSaveTicketDataProcess.class).execute(request);
    }

    @Override
    public CommonResponse saveTicketLabels(@RequestBody SaveTicketLabelsRequest request) {
        return process(TicketSaveLabelsProcess.class).execute(request);
    }

    @Override
    public CommonResponse saveTicketDetailLabels(@RequestBody SaveTicketDetailLabelsRequest request) {
        return process(DetailSaveLabelsProcess.class).execute(request);
    }

    @Override
    public CommonResponse getHistoryLabels(@Valid GetHistoryLabelsRequest request) {
        return process(GetHistoryLabelsProcess.class).execute(request);
    }

    @Override
    public CommonResponse selectTicketAttachment(SelectTicketAttachmentRequest request) {
        return selectTicketAttachmentProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse submitTicket(@RequestBody SubmitTicketRequest request) {
        return process(DefaultSubmitTicketProcess.class).execute(request);
    }

    @Override
    public CommonResponse reCheckTicket(@RequestBody ReCheckTicketRequest request) {
        return reCheckTicketProcess.execute(request);
    }

    @Override
    public CommonResponse reSendTicket(@RequestBody ReSendTicketRequest request) {
        return reSendTicketProcess.execute(request);
    }

    @Override
    public CommonResponse reSendTickets(@RequestBody ReSendTicketsRequest request) {
        return reSendTicketProcess.processBatch(request);
    }

    @Override
    public CommonResponse getInvoiceTypeList(@Valid GetTicketTypeListRequest request) {
        return getInvoiceTypeListProcess.execute(request);
    }

    @Override
    public CommonResponse getBaseTicketList(@RequestBody GetBaseTicketListRequest request) {
        return getBaseTicketListProcess.execute(request);
    }

    @RedisLockMD5
    @ApiOperation("发送验签")
    @RequestMapping(value = "/ticket/sendPDFVerify",
        produces = {"application/json"},
        method = RequestMethod.POST)
    public CommonResponse sendPDFVerify(@RequestBody SendVerifyRequest sendVerifyRequest) {
        return sendPDFVerifyProcess.execute(sendVerifyRequest);
    }

    @RedisLockMD5
    @ApiOperation("批量通过验签")
    @RequestMapping(value = "/ticket/pdfVerifyPass",
        produces = {"application/json"},
        method = RequestMethod.POST)
    public CommonResponse pdfVerifyPass(@RequestBody BatchTicketRequest batchRequest) {
        return pdfVerifyPassProcess.execute(batchRequest);
    }

    @Override
    public CommonResponse getRepeatTicket(@PathVariable("ticketId") Long ticketId, BaseRequest request) {
        return getRepeatTicketProcess.execute(ticketId, request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse operationDeleteTicket(@RequestBody DeleteTicketListRequest request) {
        return operationDeleteTicketProcess.execute(request);
    }

    @Override
    public CommonResponse getVerifyTag(Long ticketId) {
        return getVerifyTagProcess.execute(new GetVerifyTagRequest(ticketId));
    }

    @Override
    public CommonResponse submitCancel(@RequestBody SubmitCancelRequest request) {
        return submitCancelProcess.execute(request);
    }

    @RedisLockMD5
    @ApiOperation("提交前置检测")
    @PostMapping(value = "/ticket/submitCheck")
    public CommonResponse submitCheck(@RequestBody SubmitTicketRequest request) {
        return submitCheckProcess.execute(request);
    }

    @RedisLockMD5
    @ApiOperation("二维码扫码采集")
    @PostMapping(value = "/ticket/upload/qrcode")
    public CommonResponse uploadByQrcode(@RequestBody UploadByQrcodeRequest request) {
        return uploadByQrcodeProcess.execute(request);
    }

    @RedisLockMD5
    @ApiOperation("非增票退回")
    @PostMapping(value = "/ticket/backNonInvoice")
    public CommonResponse backNonInvoice(@RequestBody BackNonInvoiceRequest request) {
        return backNonInvoiceProcess.execute(request);
    }

    @RedisLockMD5
    @ApiOperation("二维码扫码采集")
    @PostMapping(value = "/ticket/insertBill/qrcode")
    public CommonResponse insertBillByQrcode(@RequestBody UploadByQrcodeRequest request) {
        return insertBillByQrcodeProcess.execute(request);
    }

}