package com.xforceplus.elephant.image.controller.ticket.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.process.response.ListResult;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.GetClaimTicketListRequest;
import com.xforceplus.elephant.image.core.domain.ticket.TicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.Collections;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetClaimTicketListProcess extends AbstractProcess<GetClaimTicketListRequest, ListResult<JSONObject>> {

    @Autowired
    private TicketService ticketDataService;

    @Override
    protected void check(GetClaimTicketListRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getIsPublic())) {
            throw new ValidationException("影像是否公共扫描标识【isPublic】不能为空");
        }
    }

    @Override
    protected CommonResponse<ListResult<JSONObject>> process(GetClaimTicketListRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        //TODO 联表查询影像
        final ListResult<JSONObject> result = new ListResult(0L, Collections.emptyList());
        return CommonResponse.ok("成功", result);
    }

}