package com.xforceplus.elephant.image.controller.ticket.process;

import com.google.common.collect.Lists;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.AbstractKeyProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.core.domain.ticket.TicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.List;
import java.util.Map;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Slf4j
@Service
@RequiredArgsConstructor
public class GetRepeatTicketProcess extends AbstractKeyProcess<Long, BaseRequest, List<Map>> {
    private final TicketService ticketService;

    @Override
    protected void check(Long ticketId, BaseRequest request) throws ValidationException {
        checkEmpty(ticketId, "发票id不能为空！");
    }

    @Override
    protected CommonResponse<List<Map>> process(Long ticketId, BaseRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        final Map<String, Object> ticketMap = ticketService.selectByTicketCode(EntityMeta.Ticket.code(), ticketId);
        final String repeatTag = StringHelp.safeToString(ticketMap.get(EntityMeta.Ticket.REPEAT_TAG.code()));
        final List<Map> ticketList = Lists.newArrayList();
        if (ValidatorUtil.isEmpty(ticketMap.get(EntityMeta.Ticket.REPEAT_TAG.code()))) {
            ticketList.add(ticketMap);
            return CommonResponse.ok("", ticketList);
        } else {
            final List<Map<String, Object>> mapList = ticketService.selectTicketByRepeatTagAmount(authorizedUser.getTenantId(), repeatTag);
            ticketList.addAll(mapList);
        }
        return CommonResponse.ok("", ticketList);
    }
}
