package com.xforceplus.elephant.image.controller.ticket.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.GetTicketTypeListRequest;
import com.xforceplus.elephant.image.core.business.application.collect.ticket.domain.TicketTypeConfig;
import com.xforceplus.elephant.image.core.facade.application.collect.ticket.TicketFacade;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.List;
import javax.validation.ValidationException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class GetTicketTypeListProcess extends AbstractProcess<GetTicketTypeListRequest, List<TicketTypeConfig>> {

    @Autowired
    private TicketFacade ticketFacade;

    @Override
    protected void check(GetTicketTypeListRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getPageCode())) {
            throw new ValidationException("页面code【pageCode】不能为空");
        }
    }

    @Override
    protected CommonResponse<List<TicketTypeConfig>> process(GetTicketTypeListRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        //ticketService.getUltPageBoItemList 改为数据字典配置
        final List<TicketTypeConfig> ticketTypeList = ticketFacade.getTicketTypeList(authorizedUser.getTenantId(), request.getPageCode());
        return CommonResponse.ok("成功", ticketTypeList);
    }

}