package com.xforceplus.elephant.image.controller.ticket.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.UploadByQrcodeRequest;
import com.xforceplus.elephant.image.core.business.application.collect.upload.service.QrcodeService;
import com.xforceplus.elephant.image.core.business.application.config.common.service.ConfigService;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.elephant.image.core.expand.bean.TicketRecogBean;
import com.xforceplus.elephant.image.core.facade.application.collect.bill.BillFacade;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.ConfigSettings;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Slf4j
@RequiredArgsConstructor
@Service
public class InsertBillByQrcodeProcess extends AbstractProcess<UploadByQrcodeRequest, Long> {
    private final BillFacade billFacade;
    private final QrcodeService qrcodeService;
    private final ImageService imageService;
    private final ConfigService configService;
    private final BillImageTicketService billImageTicketService;

    @Override
    protected void check(final UploadByQrcodeRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getQrcode(), "二维码不能为空");
        checkEmpty(request.getBillCode(), "单据CODE不能为空");
    }

    @Override
    protected CommonResponse<Long> process(final UploadByQrcodeRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final BaseBill baseBill = billFacade.selectBaseBillByCode(user.getTenantId(), request.getBillCode(), EntityMeta.BaseBill.code());
        checkEmpty(baseBill, "单据不存在");
        if (!Arrays.asList(BillDataStatus._0.getCode(), BillDataStatus._2.getCode(), BillDataStatus._6.getCode(), BillDataStatus._4.getCode())
            .contains(baseBill.getBillDataStatus())) {
            return CommonResponse.failed("单据非待提交/暂挂起/已提交/已退回状态不可补扫上传影像");
        }
        //解析二维码获得单证信息
        Ticket ticket = null;
        try {
            ticket = qrcodeService.analyzeQrcode(request.getQrcode());
        } catch (Exception e) {
            log.error("二维码解析异常", e);
        }
        if (ticket == null) {
            return CommonResponse.failed("二维码信息无法识别");
        }
        final ConfigSettings configSettings = configService.selectSettings(user.getTenantId());
        if (configSettings == null || StringUtils.isEmpty(configSettings.getEmptyUrl())) {
            return CommonResponse.failed("当前租户未配置默认图");
        }
        //初始化影像
        final Image image = qrcodeService.initQrcodeImage();
        image.setBillCode(baseBill.getBillCode());
        image.setBillEntityCode(baseBill.getBillTypeCode());
        image.setPurchaserTenantId(baseBill.getPurchaserTenantId());
        image.setPurchaserTenantCode(baseBill.getPurchaserTenantCode());
        image.setImageSource(request.getSystemOrig());
        image.setFileUrlHandle(qrcodeService.randomUrl(configSettings.getEmptyUrl()));
        image.setFileUrl(qrcodeService.randomUrl(configSettings.getEmptyUrl()));
        image.setCreateUserId(user.getId());
        image.setCreateUserName(user.getUserName());
        image.setCreateUserCode(user.getUserCode());
        image.setFileOrder(String.valueOf(baseBill.getImageCount() + 1));
        imageService.saveImages(Arrays.asList(image));

        //补充单证
        ticket.setImageId(image.getId());
        ticket.setImageOTMTicketId(image.getId());
        ticket.setBillCode(baseBill.getBillCode());
        ticket.setBillEntityCode(baseBill.getBillTypeCode());
        ticket.setPurchaserTenantId(baseBill.getPurchaserTenantId());
        ticket.setPurchaserTenantCode(baseBill.getPurchaserTenantCode());
        ticket.setIsHooked(YesNo._1.getCode());
        ticket.setBatchNo(image.getBatchNo());
        ticket.setSystemOrig(request.getSystemOrig());
        ticket.setSystemSource(request.getSystemOrig());
        ticket.setCreateUserId(user.getId());
        ticket.setCreateUserName(user.getUserName());
        ticket.setCreateUserCode(user.getUserCode());

        //创建并触发验真
        final TicketRecogBean bean = new TicketRecogBean();
        bean.setImageId(image.getId());
        bean.setTenantId(user.getTenantId());
        bean.setBatchNo(image.getBatchNo());
        bean.setIsPublic(image.getIsPublic());
        bean.setScanUserId(user.getId());
        bean.setScanUserName(user.getUserName());
        final JSONObject discern = new JSONObject(ticket.toOQSMap());
        final Map<String, Object> data = new HashMap<>();
        data.put("entityCode", ticket.getTicketCode());
        data.put("recogJson", discern);
        bean.setRecogList(Arrays.asList(data));
        billImageTicketService.insertOrUpdateRecogInfo(bean);

        //触发计算
        billImageTicketService.resetLevel(user.getTenantId(), request.getBillCode());
        return CommonResponse.ok("成功", image.getId());
    }

}