package com.xforceplus.elephant.image.controller.ticket.process;

import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.ReSendTicketRequest;
import com.xforceplus.elephant.image.client.model.ReSendTicketsRequest;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.domain.collaboration.CooperationService;
import com.xforceplus.elephant.image.core.domain.common.TicketSupport;
import com.xforceplus.elephant.image.core.domain.operationlog.OperationLogService;
import com.xforceplus.elephant.image.core.domain.ticket.TicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.OperationEntity;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.OperationType;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReSendTicketProcess extends AbstractProcess<ReSendTicketRequest, Boolean> {

    @Autowired
    private TicketService ticketService;
    @Autowired
    private MQUtils rabbitmqUtils;
    @Autowired
    private OperationLogService operationLogService;
    @Autowired
    private TicketSupport ticketSupport;
    @Autowired
    private CooperationService cooperationService;

    @Override
    protected void check(ReSendTicketRequest request) throws ValidationException {
        checkEmpty(request.getTicketId(), "单证id不能为空");
        checkEmpty(request.getTicketCode(), "单证code不能为空");
    }

    @Override
    protected CommonResponse<Boolean> process(ReSendTicketRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final String rateKey = String.format("RESENDTICKET:%s:%s", user.getTenantId(), request.getTicketId());
        if (!ticketSupport.acquireByLimiter(rateKey)) {
            return CommonResponse.failed("请求速率过快！请稍后重试!");
        }
        final Map<String, Object> ticket = ticketService.selectByTicketCode(request.getTicketCode(), request.getTicketId());
        if (ValidatorUtil.isEmpty(ticket)) {
            return CommonResponse.failed("未查询到该单证");
        }
        final Long tenantId = Long.valueOf(String.valueOf(ticket.get("tenant_id")));
        final Long imageId = Long.valueOf(String.valueOf(ticket.get("image_id")));
        cooperationService.syncTicket(tenantId, user.getTenantCode(), imageId, "手工-重新下发");
        operationLogService.insertOperationLog(OperationEntity.TICKET.getCode(), StringHelp.safeToString(request.getTicketId()), OperationType.PUSH_TICKET.getCode(),
            user.getUsername(), "");
        return CommonResponse.ok("重新下发成功");
    }

    public CommonResponse<Boolean> processBatch(ReSendTicketsRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final AtomicInteger count = new AtomicInteger(0);
        request.getImageIds().stream().filter(imageId -> {
            final String rateKey = String.format("RESENDTICKETS:%s:%s", user.getTenantId(), imageId);
            return ticketSupport.acquireByLimiter(rateKey);
        }).forEach(imageId -> {
            cooperationService.syncTicket(user.getTenantId(), user.getTenantCode(), imageId, "手工-批量重新下发");
            count.incrementAndGet();
        });
        return CommonResponse.ok("批量重新下发成功,总共:" + request.getImageIds().size() + ",成功:" + count.get());
    }

}
