package com.xforceplus.elephant.image.controller.ticket.process;

import static com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE;

import com.google.common.collect.Maps;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.SendVerifyRequest;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.facade.application.collect.ticket.TicketFacade;
import com.xforceplus.elephant.image.core.facade.base.BaseFacade;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.CheckSignStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.HashMap;
import java.util.Map;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

@Service
@RequiredArgsConstructor
public class SendPDFVerifyProcess extends AbstractProcess<SendVerifyRequest, Object> {

    private final BaseFacade baseFacade;
    private final MQUtils rabbitmqUtils;
    private final TicketFacade ticketFacade;

    @Override
    protected void check(SendVerifyRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getTicketId())) {
            throw new ValidationException("单证ID【ticketId】不能为空");
        }
    }

    @Override
    protected CommonResponse process(SendVerifyRequest request) throws RuntimeException {
        final Map<String, Object> entityMap = baseFacade.findOne(EntityMeta.Ticket.code(), request.getTicketId());
        if (null == entityMap) {
            return CommonResponse.failed("没有找到可操作的数据.");
        }
        final String checkSignStatus = String.valueOf(entityMap.get(EntityMeta.Ticket.CHECK_SIGN_STATUS.code()));
        if (CheckSignStatus._1.getCode().equals(checkSignStatus)) {
            return CommonResponse.failed("发票已验签成功，无需验签.");
        }
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆.");
        }
        //发送验签
        final String result = ticketFacade.pdfVerify(entityMap);
        //发送mq,校验单证异常预警信息
        final String ticketCode = String.valueOf(entityMap.get(EntityMeta.Ticket.TICKET_CODE.code()));
        final Map<String, Object> paramMap = Maps.newHashMap();
        paramMap.put("ticketId", request.getTicketId());
        paramMap.put("ticketCode", ticketCode);
        paramMap.put("source", "验签后重算异常预警");
        final Map<String, Object> headers = new HashMap<>();
        headers.put(TENANT_CODE, authorizedUser.getTenantCode());
        rabbitmqUtils.sendByDirectExchange(MQEnum.CHECK_TICKET_EXCE_WARN_QUEUE, paramMap, headers);
        //重算异常
        return CheckSignStatus._1.getDesc().equals(result) ? CommonResponse.ok(result) : CommonResponse.failed(result);
    }

}