package com.xforceplus.elephant.image.controller.ticket.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.UploadByQrcodeRequest;
import com.xforceplus.elephant.image.core.business.application.collect.image.service.ImageService;
import com.xforceplus.elephant.image.core.business.application.collect.upload.service.QrcodeService;
import com.xforceplus.elephant.image.core.business.application.config.common.service.ConfigService;
import com.xforceplus.elephant.image.core.business.consts.Constants;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.elephant.image.core.expand.bean.TicketRecogBean;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.CalculateStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ExceptionStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageSource;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.InvoiceType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.IsPublic;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.RecStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.ConfigSettings;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Slf4j
@RequiredArgsConstructor
@Service
public class UploadByQrcodeProcess extends AbstractProcess<UploadByQrcodeRequest, Long> {

    private final ConfigService configService;
    private final QrcodeService qrcodeService;
    private final ImageService imageService;
    private final BillImageTicketService billImageTicketService;

    @Override
    protected void check(final UploadByQrcodeRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getQrcode(), "二维码不能为空");
    }

    @Override
    protected CommonResponse<Long> process(final UploadByQrcodeRequest request) throws RuntimeException {
        //解析二维码获得单证信息
        Ticket ticket = null;
        try {
            ticket = qrcodeService.analyzeQrcode(request.getQrcode());
        } catch (Exception e) {
            log.error("二维码解析异常", e);
        }
        if (ticket == null) {
            return CommonResponse.failed("二维码信息无法识别");
        }
        final IAuthorizedUser user = UserInfoHolder.get();
        final ConfigSettings configSettings = configService.selectSettings(user.getTenantId());
        if (configSettings == null || StringUtils.isEmpty(configSettings.getEmptyUrl())) {
            return CommonResponse.failed("当前租户未配置默认图");
        }
        //初始化影像
        final Image image = qrcodeService.initQrcodeImage();
        image.setBillCode(StringUtils.EMPTY);
        image.setImageSource(request.getSystemOrig());
        image.setFileUrlHandle(qrcodeService.randomUrl(configSettings.getEmptyUrl()));
        image.setFileUrl(qrcodeService.randomUrl(configSettings.getEmptyUrl()));
        image.setCreateUserId(user.getId());
        image.setCreateUserName(user.getUserName());
        image.setCreateUserCode(user.getUserCode());
        imageService.createMulti(Arrays.asList(image), EntityMeta.Image.code());

        //补充单证
        ticket.setImageId(image.getId());
        ticket.setImageOTMTicketId(image.getId());
        ticket.setBatchNo(image.getBatchNo());
        ticket.setSystemOrig(request.getSystemOrig());
        ticket.setSystemSource(request.getSystemOrig());
        ticket.setCreateUserId(user.getId());
        ticket.setCreateUserName(user.getUserName());
        ticket.setCreateUserCode(user.getUserCode());

        //创建并触发验真
        final TicketRecogBean bean = new TicketRecogBean();
        bean.setImageId(image.getId());
        bean.setTenantId(user.getTenantId());
        bean.setBatchNo(image.getBatchNo());
        bean.setIsPublic(image.getIsPublic());
        bean.setScanUserId(user.getId());
        bean.setScanUserName(user.getUserName());
        final JSONObject discern = new JSONObject(ticket.toOQSMap());
        final Map<String, Object> data = new HashMap<>();
        data.put("entityCode", ticket.getTicketCode());
        data.put("recogJson", discern);
        bean.setRecogList(Arrays.asList(data));
        billImageTicketService.insertOrUpdateRecogInfo(bean);

        //触发重复计算
        billImageTicketService.resetLevel(image.getBatchNo(), user.getId());
        return CommonResponse.ok("成功", image.getId());
    }

}
