package com.xforceplus.elephant.image.controller.ticket.process.deleteperson;

import static com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.enums.ticket.PackageTicketStatusEnum;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.DeleteTicketListRequest;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.domain.ticket.TicketService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Dispatch(tenantCode = "CQP")
@Service
public class CQPDeletePersonTicketListProcess extends DefaultDeletePersonTicketListProcess {

    @Autowired
    private BillImageTicketService billImageTicketService;
    @Autowired
    private TicketService ticketService;
    @Autowired
    private ImageService imageService;
    @Autowired
    private MQUtils rabbitmqUtils;

    @Override
    protected void check(DeleteTicketListRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getTicketIds())) {
            throw new ValidationException("单证ID集合【ticketIds】不能为空");
        }
        if (ValidatorUtil.isEmpty(request.getTicketCode())) {
            throw new ValidationException("单证code【ticketCode】不能为空");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(DeleteTicketListRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        boolean result = false;
        //删除基础数据
        final Map<String, List<Long>> resultMap = billImageTicketService.deleteTicketData(
            authorizedUser.getTenantId(), request.getTicketIds(), request.getTicketCode());
        final List<Long> imageIds = resultMap.get("imageIds");
        final List<Long> ticketIds = resultMap.get("ticketIds");
        if (CollectionUtils.isEmpty(ticketIds)) {
            return CommonResponse.failed("没有找到可操作的数据");
        }
        final List<Map<String, Object>> mapList = ticketService.selectTicketByImageIdsAndCode(authorizedUser.getTenantId(), imageIds, request.getTicketCode());

        //查询发票下挂接的附件，然后一并删除
        if (!CollectionUtils.isEmpty(imageIds)) {
            final List<Long> attachmentAndSalesImageId = imageService.selectTicketAttachmentAndSalesList(authorizedUser.getTenantId(), imageIds).stream().map(Image::getId)
                .collect(Collectors.toList());
            imageIds.addAll(attachmentAndSalesImageId);
        }
        if (!CollectionUtils.isEmpty(imageIds)) {
            //删除
            result = billImageTicketService.deleteImageAndTicketByImageIds(authorizedUser.getTenantId(), imageIds);
        }
        if (result) {
            //通知套票系统删除
            mapList.forEach(map -> {
                packageTicketStatus(authorizedUser.getTenantId(), map, authorizedUser.getTenantCode());
            });
            String message = "删除成功";
            if (request.getTicketIds().size() != ticketIds.size()) {
                message = String.format("%d条记录成功删除%d条", request.getTicketIds().size(), ticketIds.size());
            }
            return CommonResponse.ok(message, true);
        } else {
            return CommonResponse.failed("无记录删除");
        }
    }

    private void packageTicketStatus(Long tenantId, Map<String, Object> entityMap, String tenantCode) {
        final Map<String, Object> resultMap = Maps.newHashMap();

        final Map<String, String> tags = Maps.newHashMap();
        final Map<String, Object> message = Maps.newHashMap();
        tags.put("tenantId", String.valueOf(tenantId));
        tags.put("packageTicketStatus", PackageTicketStatusEnum.DELETE.getCode());
        tags.put("payLoadId", ValidatorUtil.isEmpty(entityMap.get("invoice_no")) ? StringHelp.safeToString(entityMap.get("image_id")) : StringHelp.safeToString(entityMap.get("invoice_no")));
        tags.put("tenantCode", ValidatorUtil.isEmpty(entityMap.get("tenant_code")) ? tenantCode : StringHelp.safeToString(entityMap.get("tenant_code")));
        message.put("packageTicketStatus", PackageTicketStatusEnum.DELETE.getCode());
        message.put("ticketId", entityMap.get("id"));
        message.put("imageId", entityMap.get("image_id"));
        message.put("invoiceNo", entityMap.get("invoice_no"));
        message.put("invoiceCode", entityMap.get("invoice_code"));
        message.put("packageTicketStatus", PackageTicketStatusEnum.DELETE.getCode());
        resultMap.put("message", message);
        resultMap.put("tags", tags);

        final String sealedMessage = JSON.toJSONString(resultMap);

        final Map<String, Object> pushMap = Maps.newHashMap();
        pushMap.put("tenantId", tenantId);
        pushMap.put("sealedMessage", sealedMessage);
        final Map<String, Object> headers = new HashMap<>();
        headers.put(TENANT_CODE, UserInfoHolder.get().getTenantCode());
        rabbitmqUtils.sendByDirectExchange(MQEnum.SYNC_PACKAGE_TICKET_STATUS_QUEUE, pushMap, headers);
    }

}
