package com.xforceplus.elephant.image.controller.ticket.process.submit;

import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.SubmitTicketRequest;
import com.xforceplus.elephant.image.core.facade.application.calculate.commit.TicketCommitFacade;
import com.xforceplus.elephant.image.core.facade.dto.commit.TicketCommitDto;
import com.xforceplus.elephant.image.core.facade.dto.commit.TicketCommitFailDto;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.Set;
import javax.validation.ValidationException;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Description: 单证提交默认process类
 * @Author liming
 * @Date 2020/8/20 15:23
 */
@Dispatch(isDefault = true)
@Service
public class DefaultSubmitTicketProcess extends AbstractProcess<SubmitTicketRequest, Set<TicketCommitFailDto>> {

    @Autowired
    private TicketCommitFacade ticketCommitFacade;

    @Override
    protected void check(SubmitTicketRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getImageIds())) {
            throw new ValidationException("请先勾选发票");
        }
    }

    @Override
    protected CommonResponse<Set<TicketCommitFailDto>> process(SubmitTicketRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        logger.info("提交发票请求,tenantId:{},tenantCode:{},ids:{}", authorizedUser.getTenantId(), authorizedUser.getTenantCode(), request.getImageIds());
        final TicketCommitDto ticketCommitDto = TicketCommitDto.builder()
            .tenantId(authorizedUser.getTenantId())
            .userId(authorizedUser.getId())
            .userName(authorizedUser.getUsername())
            .imageIds(request.getImageIds())
            .backRemark(request.getBackRemark())
            .type(request.getType())
            .ticketEntityCode(EntityMeta.Ticket.code())
            .imageEntityCode(EntityMeta.Image.code())
            .build();
        ticketCommitFacade.commitTicket(ticketCommitDto);
        return CommonResponse.ok(CollectionUtils.isEmpty(ticketCommitDto.getFailDtoList()) ? "提交发票成功" : "提交发票失败", ticketCommitDto.getFailDtoList());
    }

}
