package com.xforceplus.elephant.image.controller.ticketsourcefile;

import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.TicketSourceFileApi;
import com.xforceplus.elephant.image.client.model.UploadFileRequest;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.ticketsourcefile.process.UploadFileProcess;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;

/**
 * 版权：    上海云砺信息科技有限公司 创建者: 创建时间: 功能描述: 修改历史:
 */
@ApiV1Image
public class TicketSourceFileController extends BaseController implements TicketSourceFileApi {

    @Autowired
    private UploadFileProcess uploadFileProcess;

    @CrossOrigin
    @Override
    public Object uploadFile(@Valid UploadFileRequest request) {
        return uploadFileProcess.execute(request);
    }

}
