package com.xforceplus.elephant.image.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.rabbitmq.client.Channel;
import com.xforceplus.elephant.basecommon.enums.common.WebsocketNoticeTypeEnum;
import com.xforceplus.elephant.basecommon.rabbitmq.BaseRabbitmqListener;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.ImageDTO;
import com.xforceplus.elephant.image.core.business.consts.Constants;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Component;

@Component
public class CompareWebsocketNoticeListener extends BaseRabbitmqListener {

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private CompareImageService imageService;
    @Autowired
    private SimpMessagingTemplate simpMessagingTemplate;

    @RabbitListener(bindings = @QueueBinding(value = @Queue(value = MQEnum.COMPARE_WEBSOCKET_NOTICE_QUEUE), exchange = @Exchange(value =  MQEnum.TOPIC_EXCHANGE, type = "topic"),
        key = MQEnum.COMPARE_WEBSOCKET_NOTICE_QUEUE))
    @Override
    public void onMessage(final Message message, final Channel channel) throws Exception {
        final String str = new String(message.getBody());
        logger.info("接收到影响识别完成消息:{}", str);
        final String tenantCode = MapUtils.getString(message.getMessageProperties().getHeaders(), Constants.TENANT_CODE);
        final JSONObject notice = JSON.parseObject(str);
        final Long tenantId = notice.getLong("tenantId");
        final Long createUserId = notice.getLong("createUserId");
        final String billCode = notice.getString("billCode");
        try {
            final WebsocketNoticeTypeEnum websocketNoticeTypeEnum =
                WebsocketNoticeTypeEnum.fromCode(notice.getString("noticeType"));
            if (websocketNoticeTypeEnum != null) {
                switch (websocketNoticeTypeEnum) {
                    case CHECK_EXCEPTION_AND_WARNING:
                        if (createUserId != null && createUserId > 0) {
                            simpMessagingTemplate.convertAndSend("/topic/compare/checkExcepAndWarn/user/" + createUserId, "true");
                        }
                        if (ValidatorUtil.isNotEmpty(billCode)) {
                            final List<Image> images = imageService.selectImageByBillCode(tenantId, billCode);
                            final List<ImageDTO> dtos = images.stream().map(image -> {
                                final ImageDTO dto = new ImageDTO();
                                dto.setId(image.getId());
                                dto.setExceptionStatus(image.getExceptionStatus());
                                dto.setExceptionInfo(image.getExceptionInfo());
                                dto.setWarningInfo(image.getWarningInfo());
                                return dto;
                            }).collect(Collectors.toList());
                            simpMessagingTemplate.convertAndSend("/topic/compare/checkExcepAndWarn/bill/" + billCode, dtos);
                        }
                        return;
                    case IMAGE_DISCERN:
                        Map<String, Integer> countMap = null;
                        if (createUserId != null && createUserId > 0) {
                            countMap = imageService.countRecStatusByCreateUserId(createUserId);
                            final Map<Object, Object> messageMap = new HashMap<>(countMap);
                            if (notice.getBooleanValue("isBill")) {
                                messageMap.put("billCode", billCode);
                            }
                            logger.info("给用户【{}】发送数据：【{}】", createUserId, messageMap);
                            simpMessagingTemplate.convertAndSend("/topic/compare/user/" + createUserId, messageMap);
                        }
                        if (ValidatorUtil.isNotEmpty(billCode)) {
                            countMap = imageService.countRecStatusByBillCode(tenantId, billCode, tenantCode);
                            logger.info("给单据【{}】发送数据：【{}】", billCode, countMap);
                            simpMessagingTemplate.convertAndSend("/topic/compare/bill/" + billCode, countMap);
                        }
                        return;
                    case NOT_SElF_COMPANY_TICKET:
                        final String batchNo = notice.getString("batchNo");
                        simpMessagingTemplate.convertAndSend("/topic/compare/BillBatchNo/" + billCode, batchNo);
                        return;
                    default:
                        return;
                }
            }
        } catch (final Exception e) {
            logger.error("异常预警通知处理失败", e);
        }
    }

}
