package com.xforceplus.elephant.image.mapper;

import com.xforceplus.elephant.image.client.model.EntityFieldDTO;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import java.util.List;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;

@Mapper
public interface FieldMapper {

    List<EntityFieldDTO> mapper(List<IEntityField> entityFields);

    @Mapping(target = "field", expression = "java(entityField.name())")
    @Mapping(target = "name", expression = "java(entityField.cnName())")
    @Mapping(target = "type", expression = "java(entityField.type().name())")
    @Mapping(target = "dictId", expression = "java(entityField.dictId())")
    EntityFieldDTO mapper(IEntityField entityField);

    @AfterMapping
    default void mapper(@MappingTarget EntityFieldDTO entityFieldDTO, IEntityField entityField) {
        if (entityFieldDTO.getName() == null) {
            entityFieldDTO.setName(entityFieldDTO.getField());
        }
    }
}
