package com.xforceplus.elephant.image.mapper;

import com.xforceplus.elephant.image.client.model.BillSelectAllRequest;
import com.xforceplus.elephant.image.client.model.GetImageListRequest;
import com.xforceplus.elephant.image.client.model.ImageDTO;
import com.xforceplus.elephant.image.client.model.SendVerifyRequest;
import com.xforceplus.elephant.image.core.domain.image.bean.ImageSearchBean;
import com.xforceplus.elephant.image.core.domain.image.bean.ImageSearchResultBean;
import com.xforceplus.elephant.image.core.facade.dto.statistics.TicketStatisticsDto;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

/**
 * image-service-saas
 *
 * @author liuhongbin
 * @date 2022-03-30 19:37
 */
@Mapper
public interface ImageSearchMapper {

    ImageSearchBean map(GetImageListRequest request);

    ImageSearchBean map(BillSelectAllRequest request);

    ImageSearchBean map(SendVerifyRequest request);

    @Mappings({
        @Mapping(target = "recStartTime", ignore = true),
        @Mapping(target = "recEndTime", ignore = true),
        @Mapping(target = "createTime", ignore = true),
        @Mapping(target = "updateTime", ignore = true),
        @Mapping(target = "commitTime", ignore = true),
        @Mapping(source = "imageSource", target = "systemOrig"),
        @Mapping(source = "imageSource", target = "imageSource"),
    })
    ImageDTO map(Image image);

    @Mapping(target = "totalImageNum", source = "totalNum")
    ImageSearchResultBean map(TicketStatisticsDto dto);

}
