package com.xforceplus.elephant.image.servicehandler;

import static com.xforceplus.elephant.image.core.business.consts.Constants.IMAGE_PREFIX;

import com.xforceplus.elephant.image.core.business.config.aop.annotation.MainTenant;
import com.xforceplus.elephant.image.core.util.CommonEntityServiceHandler;
import com.xforceplus.general.utils.json.JsonUtil;
import com.xforceplus.tech.base.core.dispatcher.anno.QueryHandler;
import com.xforceplus.ultraman.sdk.core.cmd.ConditionSearchCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleCreateCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleQueryCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleUpdateCmd;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.List;
import java.util.Map;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Component;

@Component
@RequiredArgsConstructor
public class CheckSystemConfigHandler extends CommonEntityServiceHandler {

    @MainTenant
    @QueryHandler(condition = "msg.getMetaData().get('code').equals('checkSystemConfig')")
    @Override
    public Either<String, Map<String, Object>> singleQuery(SingleQueryCmd cmd) {
        return super.singleQuery(cmd);
    }

    @MainTenant
    @QueryHandler(condition = "msg.getMetaData().get('code').equals('checkSystemConfig')")
    @CacheEvict(cacheNames = IMAGE_PREFIX + "checkSystemConfig", allEntries = true)
    @Override
    public Either<String, Long> singleCreate(SingleCreateCmd cmd) {
        final String settings = MapUtils.getString(cmd.getBody(), "settings");
        if (StringUtils.startsWithAny(settings, "[", "{") && !JsonUtil.isValid(settings)) {
            return Either.left("配置json数据格式不对");
        }
        return super.singleCreate(cmd);
    }

    @MainTenant
    @QueryHandler(condition = "msg.getMetaData().get('code').equals('checkSystemConfig')")
    @CacheEvict(cacheNames = IMAGE_PREFIX + "checkSystemConfig", allEntries = true)
    @Override
    public Either<String, Integer> singleUpdate(SingleUpdateCmd cmd) {
        final String settings = MapUtils.getString(cmd.getBody(), "settings");
        if (StringUtils.startsWithAny(settings, "[", "{") && !JsonUtil.isValid(settings)) {
            return Either.left("配置json数据格式不对");
        }
        return super.singleUpdate(cmd);
    }

    @MainTenant
    @QueryHandler(condition = "msg.getMetaData().get('code').equals('checkSystemConfig')")
    @Override
    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> conditionSearch(ConditionSearchCmd cmd) {
        return super.conditionSearch(cmd);
    }

}
