package com.xforceplus.elephant.image.servicehandler;

import com.google.common.collect.Maps;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.core.business.application.config.common.service.ConfigService;
import com.xforceplus.elephant.image.core.business.enums.DictEnum;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.elephant.image.core.util.CommonEntityServiceHandler;
import com.xforceplus.tech.base.core.dispatcher.anno.QueryHandler;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.sdk.core.cmd.ConditionSearchCmd;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Slf4j
@Service
@RequiredArgsConstructor
public class CompareTicketHandler extends CommonEntityServiceHandler {

    private final CompareImageService imageService;
    private final ConfigService configService;

    @QueryHandler(condition = "msg.getMetaData().get('codes').contains('compareTicket')")
    @Override
    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> conditionSearch(ConditionSearchCmd cmd) {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final StopWatch stopWatch = new StopWatch("单证查询");
        stopWatch.start("OQS查询");
        final Either<String, Tuple2<Integer, List<Map<String, Object>>>> tuple2Either = super.conditionSearch(cmd);
        if (tuple2Either.isLeft() || (tuple2Either.isRight() && tuple2Either.get()._1 == 0)) {
            stopWatch.stop();
            log.info("耗时：{}", stopWatch.prettyPrint());
            return tuple2Either;
        }
        stopWatch.stop();
        stopWatch.start("是否附件填充");
        final List<Long> imageIds = tuple2Either.get()._2.stream()
            .filter(map -> ValidatorUtil.isNotEmpty(map.get("image_id")))
            .filter(map -> Long.valueOf(map.get("image_id").toString()) > 0)
            .map(map -> Long.valueOf(map.get("image_id").toString()))
            .collect(Collectors.toList());
        Map<Long, Image> imageMap = Maps.newHashMap();
        if (ValidatorUtil.isNotEmpty(imageIds)) {
            imageMap = imageService.selectImages(authorizedUser.getTenantId(), imageIds)
                .stream().collect(Collectors.toMap(Image::getId, Function.identity(), (o1, o2) -> o2));
        }
        final List<String> tenantCodes = configService.selectDict(0L, DictEnum.NEED_WRAPPER_URL_TENANT_CONFIG.getCode(), String.class);
        for (Map<String, Object> map : tuple2Either.get()._2) {
            if (ValidatorUtil.isNotEmpty(map.get("image_id"))) {
                final Long imageId = Long.valueOf(map.get("image_id").toString());
                final Image image;
                if ((image = imageMap.get(imageId)) != null) {
                    String fileUrl = ApiV1Image.PATH + "/compare/image/" + image.getId() + image.getFileTypeHandle() + "?rid=" + System.currentTimeMillis();
                    if (CollectionUtils.isNotEmpty(tenantCodes) && !CollectionUtils.containsAny(tenantCodes, authorizedUser.getTenantCode())
                        && !ImageType._3.getCode().equals(image.getImageType())) {
                        fileUrl = ValidatorUtil.isNotEmpty(image.getFileUrlLocal()) ? image.getFileUrlLocal() : image.getFileUrlHandle();
                    }
                    map.put("imageUrl", fileUrl);
                }
            }
        }
        stopWatch.stop();
        log.info("耗时：{}", stopWatch.prettyPrint());
        return tuple2Either;
    }
}