package com.xforceplus.elephant.image.servicehandler;

import static com.xforceplus.elephant.image.core.business.consts.Constants.IMAGE_PREFIX;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.image.core.business.config.aop.annotation.MainTenant;
import com.xforceplus.elephant.image.core.domain.config.ConfigDictionaryService;
import com.xforceplus.elephant.image.core.domain.dataoperatelog.DataOperateLogService;
import com.xforceplus.elephant.image.core.util.CommonEntityServiceHandler;
import com.xforceplus.general.utils.json.JsonUtil;
import com.xforceplus.tech.base.core.dispatcher.anno.QueryHandler;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.ConfigDictionary;
import com.xforceplus.ultraman.sdk.core.cmd.ConditionSearchCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleCreateCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleDeleteCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleQueryCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleUpdateCmd;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;

@Service
public class ConfigDictionaryHandler extends CommonEntityServiceHandler {

    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private ConfigDictionaryService configDictionaryService;
    @Autowired
    private DataOperateLogService operateLogService;

    @MainTenant
    @QueryHandler(condition = "msg.getMetaData().get('code').equals('configDictionary')")
    @Override
    public Either<String, Map<String, Object>> singleQuery(SingleQueryCmd cmd) {
        return super.singleQuery(cmd);
    }

    @MainTenant
    @QueryHandler(condition = "msg.getMetaData().get('code').equals('configDictionary')")
    @Override
    public Either<String, Long> singleCreate(final SingleCreateCmd cmd) {
        final Map<String, Object> params = cmd.getBody();

        final String dictValue = MapUtils.getString(params, "dict_value");

        if (StringUtils.startsWithAny(dictValue, "[", "{") && !JsonUtil.isValid(dictValue)) {
            return Either.left("配置json数据格式不对");
        }

        final ConfigDictionary entity = BeanUtils.convertObject(params, ConfigDictionary.class);
        if (configDictionaryService.canSave(entity)) {
            operateLogService.insertOperateLog(entity.getTenant(), entity.getDictDesc(), entity.getDictCode(), params.toString(), UserInfoHolder.get().getUsername());
            return super.singleCreate(cmd);
        }
        return Either.left("配置重复，无法创建");
    }

    @MainTenant
    @QueryHandler(condition = "msg.getMetaData().get('code').equals('configDictionary')")
    @Caching(evict = {
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDictionary:select"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDictionary:selectItems"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDictionary:selectItem"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDict"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDict:json"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDict:T"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDict:map"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDictObj:T"}, allEntries = true),
    })
    @Override
    public Either<String, Integer> singleUpdate(final SingleUpdateCmd cmd) {
        final String dictValue = MapUtils.getString(cmd.getBody(), "dict_value");

        if (StringUtils.startsWithAny(dictValue, "[", "{") && !JsonUtil.isValid(dictValue)) {
            return Either.left("配置json数据格式不对");
        }

        try {
            final ConfigDictionary entity = configDictionaryService.selectById(cmd.getId());
            final JSONObject oldJson = new JSONObject(entity.toOQSMap());
            operateLogService.updateOperate(entity.getTenant(), entity.getDictDesc(), entity.getDictCode(), oldJson.toString(), JSONObject.toJSONString(cmd.getBody()),
                UserInfoHolder.get().getUsername());
        } catch (final Exception e) {
            logger.error("更新数据字典日志异常...", e);

        }
        return super.singleUpdate(cmd);
    }

    @MainTenant
    @QueryHandler(condition = "msg.getMetaData().get('code').equals('configDictionary')")
    @Caching(evict = {
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDictionary:select"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDictionary:selectItems"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDictionary:selectItem"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDict"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDict:json"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDict:T"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDict:map"}, allEntries = true),
    })
    @Override
    public Either<String, Integer> singleDelete(final SingleDeleteCmd cmd) {
        try {
            final ConfigDictionary ConfigDictionary = configDictionaryService.selectById(Long.valueOf(cmd.getId()));
            final JSONObject oldJson = new JSONObject(ConfigDictionary.toOQSMap());
            operateLogService
                .deleteOperate(ConfigDictionary.getTenant(), ConfigDictionary.getDictDesc(), ConfigDictionary.getDictCode(), oldJson.toString(), UserInfoHolder.get().getUsername());
        } catch (final Exception e) {
            logger.error("删除数据字典日志异常...");
        }
        return super.singleDelete(cmd);
    }

    @MainTenant
    @QueryHandler(condition = "msg.getMetaData().get('code').equals('configDictionary')")
    @Override
    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> conditionSearch(ConditionSearchCmd cmd) {
        return super.conditionSearch(cmd);
    }

}
