package com.xforceplus.elephant.image.servicehandler;

import static com.xforceplus.elephant.image.core.business.consts.Constants.IMAGE_PREFIX;

import com.xforceplus.elephant.image.core.business.config.aop.annotation.MainTenant;
import com.xforceplus.elephant.image.core.domain.config.ConfigSettingsService;
import com.xforceplus.elephant.image.core.util.CommonEntityServiceHandler;
import com.xforceplus.tech.base.core.dispatcher.anno.QueryHandler;
import com.xforceplus.ultraman.sdk.core.cmd.ConditionSearchCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleCreateCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleDeleteCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleQueryCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleUpdateCmd;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;

@Service
public class ConfigSettingsHandler extends CommonEntityServiceHandler {

    @Autowired
    private ConfigSettingsService configSettingsService;

    @MainTenant
    @QueryHandler(condition = "msg.getMetaData().get('code').equals('configSettings')")
    @Override
    public Either<String, Map<String, Object>> singleQuery(SingleQueryCmd cmd) {
        return super.singleQuery(cmd);
    }

    @MainTenant
    @QueryHandler(condition = "msg.getMetaData().get('code').equals('configSettings')")
    @Override
    public Either<String, Long> singleCreate(SingleCreateCmd cmd) {
        final Map<String, Object> params = cmd.getBody();
        String tenantId = null;
        if (params.containsKey("tenant")) {
            tenantId = String.valueOf(params.get("tenant"));
        }
        if (configSettingsService.canSave(tenantId)) {
            return super.singleCreate(cmd);
        }
        return Either.left("配置重复，无法创建");
    }

    @MainTenant
    @QueryHandler(condition = "msg.getMetaData().get('code').equals('configSettings')")
    @Caching(evict = {
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configSettings:select"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configSettings:selectOne"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configSettings:selectDefault"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configSettings:selectClass"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configSettings:selectClassDefault"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configSettings"}, allEntries = true),
    })
    @Override
    public Either<String, Integer> singleUpdate(SingleUpdateCmd cmd) {
        return super.singleUpdate(cmd);
    }

    @MainTenant
    @QueryHandler(condition = "msg.getMetaData().get('code').equals('configSettings')")
    @Caching(evict = {
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configSettings:select"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configSettings:selectOne"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configSettings:selectDefault"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configSettings:selectClass"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configSettings:selectClassDefault"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configSettings"}, allEntries = true),
    })
    @Override
    public Either<String, Integer> singleDelete(SingleDeleteCmd cmd) {
        return super.singleDelete(cmd);
    }

    @MainTenant
    @QueryHandler(condition = "msg.getMetaData().get('code').equals('configSettings')")
    @Override
    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> conditionSearch(ConditionSearchCmd cmd) {
        return super.conditionSearch(cmd);
    }

}
