package com.xforceplus.elephant.image.servicehandler;

import com.xforceplus.elephant.image.core.facade.application.collect.label.SystemLabelFacade;
import com.xforceplus.elephant.image.core.util.CommonEntityServiceHandler;
import com.xforceplus.elephant.image.core.util.PoiUtils;
import com.xforceplus.elephant.image.core.util.ValidateUtils;
import com.xforceplus.general.utils.GeneralUtil;
import com.xforceplus.tech.base.core.dispatcher.anno.QueryHandler;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.UseStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.SystemLabel;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.sdk.core.cmd.ImportCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleCreateCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleDeleteCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleQueryCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleUpdateCmd;
import io.vavr.control.Either;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Service;

/**
 * 系统标签二开
 *
 * @author rongying
 * @date 2021/3/26 15:15
 */
@RequiredArgsConstructor
@Service
public class NewSystemLabelService extends CommonEntityServiceHandler {

    private final SystemLabelFacade systemLabelFacade;

    @Override
    public Either<String, Map<String, Object>> singleQuery(SingleQueryCmd cmd) {
        return null;
    }

    @Override
    public Either<String, Integer> singleDelete(SingleDeleteCmd cmd) {
        return null;
    }

    @QueryHandler(condition = "msg.getMetaData().get('code').equals('systemLabel')")
    @Override
    public Either<String, Long> singleCreate(SingleCreateCmd cmd) {
        final String errMsg = checkLabel(cmd.getBody(), false);
        if (!("").equals(errMsg)) {
            return Either.left(errMsg);
        }

        return super.singleCreate(cmd);
    }

    @QueryHandler(condition = "msg.getMetaData().get('code').equals('systemLabel')")
    public Either<String, String> batchImport(ImportCmd cmd) {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        final int maxRows = 10000;
        int countSuccess = 0;
        int countFail = 0;
        final StringBuilder existBuilder = new StringBuilder();
        try {
            final List<Map<String, Object>> excelData = PoiUtils.convert(new XSSFWorkbook(cmd.getInputStream()));
            if (excelData.size() > maxRows) {
                ValidateUtils.throwMessage("导入的数据行不能超过" + maxRows);
            }
            final List<Map<String, Object>> dataList = excelData.stream().filter(PoiUtils.distinctByKey(a -> a.get(EntityMeta.SystemLabel.LABEL_NAME.code()))).collect(Collectors.toList());
            for (Map<String, Object> map : dataList) {
                final String labelName = GeneralUtil.asString(map.get(EntityMeta.SystemLabel.LABEL_NAME.code()));
                final String enable = GeneralUtil.asString(map.get(EntityMeta.SystemLabel.ENABLE.code()));
                final boolean exist = systemLabelFacade.checkLabelName(authorizedUser.getTenantId(), labelName, null);
                if (exist) {
                    existBuilder.append(labelName).append(",");
                } else {
                    final SystemLabel systemLabel = new SystemLabel();
                    systemLabel.setLabelName(labelName);
                    systemLabel.setEnable("启用".equals(enable) ? UseStatus._1.getCode() : UseStatus._0.getCode());
                    try {
                        systemLabelFacade.save(systemLabel);
                        countSuccess++;
                    } catch (Exception e) {
                        countFail++;
                    }
                }
            }
        } catch (IOException e) {
            ValidateUtils.throwMessage(e.getMessage());
        }
        final String existLabel = GeneralUtil.trimEnd(existBuilder.toString(), ",");
        String resultMsg = "";
        if (countSuccess > 0) {
            resultMsg += "成功数(" + countSuccess + ")";
        }
        if (countFail > 0) {
            resultMsg += "失败数(" + countFail + ")";
        }
        if (StringUtils.isNotBlank(existLabel)) {
            resultMsg += "存在标签(" + existLabel + ")";
        }
        return Either.right(resultMsg);
    }

    @QueryHandler(condition = "msg.getMetaData().get('code').equals('systemLabel')")
    @Override
    public Either<String, Integer> singleUpdate(SingleUpdateCmd cmd) {
        final String errMsg = checkLabel(cmd.getBody(), true);
        if (!("").equals(errMsg)) {
            return Either.left(errMsg);
        }

        return super.singleUpdate(cmd);
    }

    /**
     * 校验标签内容
     *
     * @param body 对象
     * @return
     */
    private String checkLabel(Map<String, Object> body, boolean isEdit) {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆.");
        }
        final String lable_name = body.getOrDefault(EntityMeta.SystemLabel.LABEL_NAME.code(), "").toString();
        if ("".equals(lable_name)) {
            return "标签名称不可为空";
        }
        Long labelId = null;
        if (isEdit) {
            labelId = Long.valueOf(body.get(EntityMeta.SystemLabel.ID.code()).toString());
        }
        final boolean isExit = systemLabelFacade.checkLabelName(authorizedUser.getTenantId(), lable_name, labelId);
        if (isExit) {
            return "标签名称已存在";
        }
        return "";
    }

}
